/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.aws.common;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.sqs.AmazonSQS;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.aws.s3.S3Service;
import net.wicp.tams.common.aws.sqs.SqsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsHelper {
    private static final Logger log = LoggerFactory.getLogger(AwsHelper.class);

    public static String buildQueueName(String queueName) {
        if (StringUtil.isNull((Object)Conf.get((String)"common.aws.sqs.receiver.queueName.prefix"))) {
            return queueName;
        }
        return Conf.get((String)"common.aws.sqs.receiver.queueName.prefix") + queueName;
    }

    public static String buildBucketName(String bucketName) {
        bucketName = StringUtil.hasNull((String[])new String[]{bucketName, StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.aws.sqs.s3.bucketName")})});
        if (StringUtil.isNull((Object)Conf.get((String)"common.aws.sqs.s3.bucketName.prefix"))) {
            return bucketName;
        }
        return Conf.get((String)"common.aws.sqs.s3.bucketName.prefix") + bucketName;
    }

    public static String buildBucketKey(String relaKey) {
        String pathTrue = relaKey;
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.aws.sqs.s3.prefix"))) {
            pathTrue = IOUtil.mergeFolderAndFilePath((String)Conf.get((String)"common.aws.sqs.s3.prefix"), (String[])new String[]{relaKey});
        }
        if (pathTrue.startsWith("/")) {
            pathTrue = pathTrue.substring(1);
        }
        return pathTrue;
    }

    public static byte[] getBytes(InputStream inputStream) {
        byte[] buffer = null;
        try {
            int n;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            inputStream.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static SqsService createSqsService() {
        try {
            Constructor<?> c0 = Class.forName("com.xforceplus.common.aws.sqs.SqsService").getDeclaredConstructor(new Class[0]);
            c0.setAccessible(true);
            SqsService retobj = (SqsService)c0.newInstance(new Object[0]);
            return retobj;
        }
        catch (Exception e) {
            log.error("\u521b\u5efaSqsService\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static SqsService createSqsService(AmazonSQS sqs) {
        try {
            Constructor<?> c0 = Class.forName("com.xforceplus.common.aws.sqs.SqsService").getDeclaredConstructor(AmazonSQS.class);
            c0.setAccessible(true);
            SqsService retobj = (SqsService)c0.newInstance(sqs);
            return retobj;
        }
        catch (Exception e) {
            log.error("\u521b\u5efaSqsService\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static S3Service createS3Service() {
        try {
            Constructor<?> c0 = Class.forName("net.wicp.tams.common.aws.s3.S3Service").getDeclaredConstructor(new Class[0]);
            c0.setAccessible(true);
            S3Service retobj = (S3Service)c0.newInstance(new Object[0]);
            return retobj;
        }
        catch (Exception e) {
            log.error("\u521b\u5efaSqsService\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static S3Service createS3Service(AmazonS3 s3) {
        try {
            Constructor<?> c0 = Class.forName("net.wicp.tams.common.aws.s3.S3Service").getDeclaredConstructor(AmazonS3.class);
            c0.setAccessible(true);
            S3Service retobj = (S3Service)c0.newInstance(s3);
            return retobj;
        }
        catch (Exception e) {
            log.error("\u521b\u5efaSqsService\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

