/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.aws;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.wicp.tams.common.aws.s3.singleton.S3ClientSingleton;
import net.wicp.tams.common.callback.IRemote;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsRemoteImpl
implements IRemote {
    private static final Logger log = LoggerFactory.getLogger(TamsRemoteImpl.class);

    public InputStream findStream(String path) {
        String pathtrue = path.replace("s3:", "").replace("//", "/");
        pathtrue = pathtrue.charAt(0) == '/' ? pathtrue.substring(1) : pathtrue;
        int firstIndexOf = pathtrue.indexOf("/");
        S3ObjectInputStream objectForStream = S3ClientSingleton.getInst().getS3().getObjectForStream(pathtrue.substring(0, firstIndexOf), pathtrue.substring(firstIndexOf + 1));
        return objectForStream;
    }

    public void findStream(String path, String localPath) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)this.findStream(path), (File)new File(localPath));
        }
        catch (IOException e) {
            log.error("\u53d6S3\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_undefined, "\u53d6S3\u6587\u4ef6\u9519\u8bef");
        }
    }
}

