/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.sts;

import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.aws.common.TamsCredentialsProvider;

@Slf4j
public class StsService {

    /***
     * 创建token
     *
     * @return
     */
    public Credentials createSessionToken(String accessKey, String secretKey) {
        try {
            // 创建sts凭证
            AWSSecurityTokenService awsSts = AWSSecurityTokenServiceClient.builder()
                    .withRegion(Conf.get("common.aws.region")).withCredentials(new TamsCredentialsProvider(accessKey, secretKey)).build();
            // 获取临时凭证秘钥
            GetSessionTokenRequest tokenRequest = new GetSessionTokenRequest();
            tokenRequest.setDurationSeconds(Conf.getInt("common.aws.sts.token.durationSeconds"));// 有效期
            return awsSts.getSessionToken(tokenRequest).getCredentials();
        } catch (Exception e) {
            log.error("获取sts临时凭证失败", e);
            throw new RuntimeException("获取sts临时凭证失败");
        }
    }

}
