/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.sqs.threadlocal;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class SqsContext implements ObjectCreator<JSONObject> {

	public static String defaultCol = "context";// 如果没有传jsonstr过来则默认设置为此列的json

	private static final String perVarSqsClient = "perVarSqsContext";

	private SqsContext() {
	}

	@Override
	public JSONObject createObject() {
		JSONObject context = new JSONObject();
		return context;
	}

	public static JSONObject createPerThreadSqsContext() {
		ObjectCreator<JSONObject> creator = PerthreadManager.getInstance().createValue(perVarSqsClient,
				new SqsContext());
		return creator.createObject();
	}

	public static void cleanContext() {
		PerthreadManager.getInstance().cleanValue(perVarSqsClient);
	}
}
