/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.sqs.listener;

import java.util.concurrent.ThreadPoolExecutor;

import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.aws.SqsData;
import net.wicp.tams.common.aws.sqs.SqsService;
import net.wicp.tams.common.aws.sqs.bean.MessageCommon;
import net.wicp.tams.common.aws.sqs.threadlocal.SqsClientThreadlocal;
import net.wicp.tams.common.aws.sqs.threadlocal.SqsContext;
import net.wicp.tams.common.thread.ThreadPool;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Slf4j
public abstract class AbsSQSListener {
	public final boolean doListener(MessageCommon msgPag) {
		boolean result = false;
		long waitTime = (System.currentTimeMillis() - msgPag.getReceiveTime()) / 1000;
		if (waitTime > msgPag.getVisibilityTimeout()) {// 线程等待时间大于可见时间，那么此线程没意义了
			String curNamespace = PerthreadManager.getInstance().createValue("tams-namespace", String.class).get();
			if (StringUtil.isNull(curNamespace)) {
				log.warn("The thread wait time is greater than the visible time，the msgid:{}",
						msgPag.getSqsData().getMessageId());
			} else {
				ThreadPoolExecutor cur = (ThreadPoolExecutor) ThreadPool.getExecutorservicemap().get(curNamespace);
				log.warn(
						"The thread wait time is greater than the visible time，the msgid:{},namespace:{},activeCount:{},allTaskCount{},coreSize:{},maxSize:{},queueSize{}",
						msgPag.getSqsData().getMessageId(), curNamespace, cur.getActiveCount(), cur.getTaskCount(),
						cur.getCorePoolSize(), cur.getMaximumPoolSize(), cur.getQueue().size());
			}
			return result;
		}
		if (StringUtil.isNotNull(msgPag.getSqsData().getContext())) {
			// context处理
			JSONObject jsonObject = null;
			try {
				jsonObject = JSONObject.parseObject(msgPag.getSqsData().getContext());
			} catch (Exception e) {// 兼容，防止.net传不合法的jsonstr
				jsonObject = new JSONObject();
				jsonObject.put(SqsContext.defaultCol, msgPag.getSqsData().getContext());
			}
			JSONObject createPerThreadSqsContext = SqsContext.createPerThreadSqsContext();
			createPerThreadSqsContext.putAll(JSONUtil.jsonToMap(jsonObject));
			// end context处理
		} else {
			// 20190703 修改threadlocal内容串掉的问题，覆盖context内容
			SqsContext.cleanContext();
		}
		SqsService.doWithTime.put(msgPag.getSqsData().getMessageId(), System.currentTimeMillis());
		try {
			result = cusListener(msgPag.getSqsData());
		} catch (Throwable e) {
			log.error("业务执行失败,id:" + msgPag.getSqsData().getMessageId(), e);
			result = false;
		}
		SqsService.doWithTime.remove(msgPag.getSqsData().getMessageId());
		try {
			if (result) {
				long doWithTime = (System.currentTimeMillis() - msgPag.getReceiveTime()) / 1000;
				if (doWithTime > msgPag.getVisibilityTimeout()) {// 线程等待时间大于可见时间
					log.warn("The thread wait time is greater than the visible time，the msgid:{}",
							msgPag.getSqsData().getMessageId());
				}
				SqsService sqsPerThread = SqsClientThreadlocal.createPerThreadSqsClient();
				sqsPerThread.deleteMessage(msgPag.getSqsData());
			}
		} catch (Exception e) {
			log.error("删除消息时失败", e);
		}
		return result;
	}

	public abstract boolean cusListener(SqsData msg);

}
