/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.s3.singleton;

import net.wicp.tams.common.aws.common.AwsHelper;
import net.wicp.tams.common.aws.s3.S3Service;

public class S3ClientSingleton {
	private static volatile S3ClientSingleton inst;

	private final S3Service s3;

	public S3Service getS3() {
		return s3;
	}

	private S3ClientSingleton() {
		s3 = AwsHelper.createS3Service();
	}

	public static S3ClientSingleton getInst() {
		if (inst == null) {
			synchronized (S3ClientSingleton.class) {
				if (inst == null) {
					inst = new S3ClientSingleton();
				}
			}
		}
		return inst;
	}

}
