/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.common;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.sqs.AmazonSQS;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.aws.s3.S3Service;
import net.wicp.tams.common.aws.sqs.SqsService;

/**
 * Created by Admin on 2018/12/17.
 */
@Slf4j
@SuppressWarnings("rawtypes")
public abstract class AwsHelper {

	/**
	 * 构建队列名
	 * 
	 * @param queueName
	 * @return
	 */
	public static String buildQueueName(String queueName) {
		if (StringUtil.isNull(Conf.get("common.aws.sqs.receiver.queueName.prefix"))) {
			return queueName;
		}
		return Conf.get("common.aws.sqs.receiver.queueName.prefix") + queueName;
	}

	/**
	 * 构建s3存储桶
	 * 
	 * @param bucketName
	 * @return
	 */
	public static String buildBucketName(String bucketName) {
		bucketName=StringUtil.hasNull(bucketName,StringUtil.hasNull(Conf.get("common.aws.sqs.s3.bucketName")));		
		if (StringUtil.isNull(Conf.get("common.aws.sqs.s3.bucketName.prefix"))) {
			return bucketName;
		}
		return Conf.get("common.aws.sqs.s3.bucketName.prefix") + bucketName;
	}

	/***
	 * 构建s3的key
	 * 
	 * @param relaKey
	 *            相对key
	 * @return
	 */
	public static String buildBucketKey(String relaKey) {
		String pathTrue = relaKey;
		if (StringUtil.isNotNull(Conf.get("common.aws.sqs.s3.prefix"))) {
			pathTrue = IOUtil.mergeFolderAndFilePath(Conf.get("common.aws.sqs.s3.prefix"), relaKey);
		}
		if (pathTrue.startsWith("/"))
			pathTrue = pathTrue.substring(1);
		return pathTrue;
	}

	/**
	 * 获得指定文件的byte数组
	 */
	public static byte[] getBytes(InputStream inputStream) {
		byte[] buffer = null;
		try {
			ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
			byte[] b = new byte[1024];
			int n;
			while ((n = inputStream.read(b)) != -1) {
				bos.write(b, 0, n);
			}
			inputStream.close();
			bos.close();
			buffer = bos.toByteArray();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return buffer;
	}

	public static SqsService createSqsService() {
		// 以下调用无参的、私有构造函数
		try {
			Constructor c0 = Class.forName("com.xforceplus.common.aws.sqs.SqsService").getDeclaredConstructor();
			c0.setAccessible(true);
			SqsService retobj = (SqsService) c0.newInstance();
			return retobj;
		} catch (Exception e) {
			log.error("创建SqsService失败", e);
			return null;
		}
	}

	public static SqsService createSqsService(AmazonSQS sqs) {
		try {
			Constructor c0 = Class.forName("com.xforceplus.common.aws.sqs.SqsService")
					.getDeclaredConstructor(AmazonSQS.class);
			c0.setAccessible(true);
			SqsService retobj = (SqsService) c0.newInstance(sqs);
			return retobj;
		} catch (Exception e) {
			log.error("创建SqsService失败", e);
			return null;
		}
	}

	public static S3Service createS3Service() {
		// 以下调用无参的、私有构造函数
		try {
			Constructor c0 = Class.forName("net.wicp.tams.common.aws.s3.S3Service").getDeclaredConstructor();
			c0.setAccessible(true);
			S3Service retobj = (S3Service) c0.newInstance();
			return retobj;
		} catch (Exception e) {
			log.error("创建SqsService失败", e);
			return null;
		}
	}

	public static S3Service createS3Service(AmazonS3 s3) {
		try {
			Constructor c0 = Class.forName("net.wicp.tams.common.aws.s3.S3Service")
					.getDeclaredConstructor(AmazonS3.class);
			c0.setAccessible(true);
			S3Service retobj = (S3Service) c0.newInstance(s3);
			return retobj;
		} catch (Exception e) {
			log.error("创建SqsService失败", e);
			return null;
		}
	}

}
