/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws;

import net.wicp.tams.common.aws.s3.S3Service;
import net.wicp.tams.common.aws.s3.singleton.S3ClientSingleton;
import net.wicp.tams.common.aws.sqs.SqsService;
import net.wicp.tams.common.aws.sqs.singleton.SqsClientSingleton;

public class AwsClientManager {
	private static volatile AwsClientManager awsClientOnlyOne;
	private final S3Service s3;
	private final SqsService sqs;

	private AwsClientManager() {
		this.sqs = SqsClientSingleton.getInst().getSqs();
		this.s3 = S3ClientSingleton.getInst().getS3();
	}

	public static AwsClientManager getInst() {
		if (awsClientOnlyOne == null) {
			synchronized (AwsClientManager.class) {
				if (awsClientOnlyOne == null) {
					awsClientOnlyOne = new AwsClientManager();
				}
			}
		}
		return awsClientOnlyOne;
	}

	public S3Service getS3() {
		return s3;
	}

	public SqsService getSqs() {
		return sqs;
	}

}
