/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.thread.event;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.util.Map;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.constant.ObjectElement;
import net.wicp.tams.common.thread.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventListener.class);

    @Subscribe
    @AllowConcurrentEvents
    public void listen(Event event) throws Exception {
        if (null == event) {
            logger.warn("EventListener.listen() event is null, do nothing");
            return;
        }
        Object[] args = event.getArgs();
        Class[] parameterTypes = event.getClazzs();
        if (null == parameterTypes && null != args && args.length > 0) {
            parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
        }
        Method method = event.getBean().getClass().getDeclaredMethod(event.getMethodName(), parameterTypes);
        method.setAccessible(true);
        method.invoke(event.getBean(), args);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void listenStatic(Map<ObjectElement, Object> inputobj) throws Exception {
        String classNamestr = String.valueOf(inputobj.get((Object)ObjectElement.className));
        String methodNamestr = String.valueOf(inputobj.get((Object)ObjectElement.methodName));
        Object[] paramsobjs = inputobj.get((Object)ObjectElement.params) == null ? null : (Object[])inputobj.get((Object)ObjectElement.params);
        ReflectAssist.invokeStaticMothed(classNamestr, methodNamestr, paramsobjs);
    }
}

