/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant.ods;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.constant.ods.AddColName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;

public enum AddColNameType implements IEnumCombobox
{
    no("\u4e0d\u589e\u52a0\u5217"),
    selective("\u53ea\u6dfb\u52a0\u914d\u7f6e\u7684\u5217"),
    selective_ori("\u53ea\u6dfb\u52a0\u914d\u7f6e\u5217\uff08\u5217\u540d\u4e3a\u9ed8\u8ba4\u503c\uff09"),
    all("\u6dfb\u52a0\u5168\u90e8\u7684\u5217"),
    all_ori("\u6dfb\u52a0\u5168\u90e8\u7684\u5217\uff08\u5217\u540d\u4e3a\u9ed8\u8ba4\u503c\uff09");

    private final String desc;

    private List<MySqlColBean> createColList(Map<AddColName, String> confmap, FieldFormart fieldFormart) {
        ArrayList<MySqlColBean> retlist = new ArrayList<MySqlColBean>();
        for (AddColName addColName : AddColName.values()) {
            MySqlColBean retobj = new MySqlColBean();
            String colName = null;
            switch (this) {
                case no: {
                    break;
                }
                case selective: {
                    if (!MapUtils.isNotEmpty(confmap) || !confmap.containsKey(addColName)) break;
                    colName = confmap.get(addColName);
                    break;
                }
                case selective_ori: {
                    if (!MapUtils.isNotEmpty(confmap) || !confmap.containsKey(addColName)) break;
                    colName = addColName.getColNameTrue(fieldFormart);
                    break;
                }
                case all: {
                    colName = addColName.getColNameTrue(fieldFormart);
                    break;
                }
                case all_ori: {
                    colName = addColName.getColNameTrue(fieldFormart);
                    break;
                }
            }
            if (!StringUtil.isNotNull(colName)) continue;
            retobj.setColumnName(colName);
            retobj.setDataType(addColName.getMysqlType());
            retlist.add(retobj);
        }
        return retlist;
    }

    public List<MySqlColBean> createColList(List<MySqlColBean> oriList, Map<AddColName, String> confmap, final FieldFormart fieldFormart) {
        List<MySqlColBean> addColList = this.createColList(confmap, fieldFormart);
        if (CollectionUtils.isEmpty(addColList)) {
            return oriList;
        }
        if (CollectionUtils.isEmpty(oriList)) {
            return addColList;
        }
        final ArrayList<String> addColNames = new ArrayList<String>();
        for (MySqlColBean addCol : addColList) {
            addColNames.add(addCol.getColumnNameStandard(fieldFormart));
        }
        CollectionUtils.filter(oriList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                MySqlColBean oriColBean = (MySqlColBean)object;
                return !addColNames.contains(oriColBean.getColumnNameStandard(fieldFormart));
            }
        });
        oriList.addAll(addColList);
        return oriList;
    }

    private AddColNameType(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDesc_zh() {
        return this.desc;
    }

    @Override
    public String getDesc_en() {
        return this.name();
    }
}

