/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.lang3.ArrayUtils;

public enum StrPattern {
    char_normal("^[a-zA-Z0-9_\u4e00-\u9fa5]+$", "\u53ea\u542b\u6709\u6c49\u5b57\u3001\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\uff0c\u4e0b\u5212\u7ebf\u4f4d\u7f6e\u4e0d\u9650"),
    char_zh("[\u4e00-\u9fa5]", "\u53ea\u542b\u6709\u4e2d\u6587\u5b57\u7b26"),
    row_blank("\\n\\s*\\r", "\u542b\u6709\u7a7a\u767d\u884c"),
    email("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*", "\u9700\u8981\u4f20\u5165eamil\u683c\u5f0f"),
    identity("\\d{15}|\\d{18}", "\u4e0d\u662f\u8eab\u4efd\u8bc1"),
    date("^[0-9]{4}\\-[0-9]{1,2}\\-[0-9]{1,2}", "\u9700\u8981\u65e5\u671f\u683c\u5f0fYYYY-M(M)-D(D)"),
    date2("^[0-9]{4}[0-9]{2}[0-9]{2}", "\u9700\u8981\u65e5\u671f\u683c\u5f0fyyyyMMdd"),
    date_time("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))( )(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))", "\u9700\u8981\u65f6\u95f4\u683c\u5f0fyyyy-MM-dd HH:mm:ss"),
    date_time2("^([0-9]{4})((0([1-9]{1}))|(1[0-2]))(([0-2]([0-9]{1}))|(3[0|1]))(([0-1]([0-9]{1}))|(2[0-4]))([0-5]([0-9]{1}))([0-5]([0-9]{1}))", "\u9700\u8981\u65f6\u95f4\u683c\u5f0fyyyyMMddHHmmss"),
    date_time_SSS("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))( )(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(.)([0-9]+)", "yyyy-MM-dd HH:mm:ss.SSS"),
    date_time_SSS2("^([0-9]{4})((0([1-9]{1}))|(1[0-2]))(([0-2]([0-9]{1}))|(3[0|1]))(([0-1]([0-9]{1}))|(2[0-4]))([0-5]([0-9]{1}))([0-5]([0-9]{1}))([0-9]+)", "yyyyMMddHHmmssSSS"),
    date_time_t1("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))", "yyyy-MM-dd'T'HH:mm:ss"),
    date_time_t12("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(.)([0-9]+)", "yyyy-MM-dd'T'HH:mm:ss.SSS"),
    date_time_t13("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))", "yyyy-MM-dd'T'HH:mm"),
    date_time_t2("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(Z)", "yyyy-MM-dd'T'HH:mm:ss'Z'"),
    date_time_t3("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(CST)", "yyyy-MM-dd'T'HH:mm:ssz"),
    mobile_phone("^(13[0-9]|15[0|3|6|7|8|9]|18[6|8|9])\\d{8}$", "\u9700\u8981\u624b\u673a\u53f7\u7801"),
    number_float("^(-?\\d+)(\\.\\d+)?$", "\u9700\u8981\u8f93\u5165\u5c0f\u6570"),
    number_float_positive("^\\d+(\\.\\d+)?$", "\u9700\u8981\u8f93\u5165\u975e\u8d1f\u5c0f\u6570"),
    number_integer("^-?\\d+$", "\u9700\u8981\u8f93\u5165\u6574\u6570"),
    number_integer_positive("^\\d+$", "\u9700\u8981\u8f93\u5165\u975e\u8d1f\u6574\u6570"),
    db_split("^\\w+_[0-9]{2}$", "\u5206\u5e93\u7684\u5e93\u540d\u4e0d\u5408\u6cd5"),
    tb_split("^\\w+_[0-9]{4}$", "\u5206\u8868\u7684\u8868\u540d\u4e0d\u5408\u6cd5"),
    split_pattern("\\s*[,]+\\s*", "\u9700\u8981\u9017\u53f7\u5206\u9694"),
    db_name_pattern("(^_([a-zA-Z0-9]_?)*$)|(^[a-zA-Z](_?[a-zA-Z0-9])*_?$)", "\u9996\u4f4d\u53ef\u4ee5\u662f\u5b57\u6bcd\u4ee5\u53ca\u4e0b\u5212\u7ebf,\u4e0b\u5212\u7ebf\u540e\u4e0d\u80fd\u63a5\u4e0b\u5212\u7ebf"),
    catalog_tb_name_pattern("(^t_([a-zA-Z0-9]_?)*$)", "\u8868\u540d\u5fc5\u987b\u4ee5t_\u5f00\u59cb,\u4e0b\u5212\u7ebf\u540e\u4e0d\u80fd\u63a5\u4e0b\u5212\u7ebf"),
    catalog_view_name_pattern("(^v_([a-zA-Z0-9]_?)*$)", "\u89c6\u56fe\u540d\u5fc5\u987b\u4ee5v_\u5f00\u59cb,\u4e0b\u5212\u7ebf\u540e\u4e0d\u80fd\u63a5\u4e0b\u5212\u7ebf"),
    rfc1123("(^([a-z0-9]-{0,1}){1,58}$)|(^[a-z](-?[a-z0-9]){1,58}-?$)", "\u53ea\u6709\u4e2d\u5212\u7ebf\u548c\u6570\u5b57\u5c0f\u5199\u5b57\u6bcd\u7ec4\u6210\uff0c\u4e14\u4e0d\u8d85\u8fc760\u4e2a\u5b57\u7b26"),
    weburl("^(http|https):\\/\\/([\\w\\.\\:\\-\\_]+)\\/?\\S*$", "\u9700\u8981http\u6216https\u5730\u5740"),
    httpurl("^(http):\\/\\/([\\w\\.\\:\\-\\_]+)\\/?\\S*$", "\u9700\u8981http\u5730\u5740"),
    httpsurl("^(https):\\/\\/([\\\\w\\.\\:\\-\\_]+)\\/?\\S*$", "\u9700\u8981https\u5730\u5740"),
    weburlsuffix("^\\.([\\w\\.\\:\\-\\_]+)$", "\u9700\u8981\u2018.\u2019\u5f00\u59cb,\u53bb\u9664\u7b2c\u4e00\u6bb5\uff0c\u5982\uff1aducckula.lcdev.cc\u7684\u540e\u7f00\u4e3a.lcdev.cc"),
    flinkversion("^(run.|data.){0,1}([0-9\\.]+)(-scala_([0-9\\\\.]+)){0,1}-java([1]{0,1}[0-9]{1})$", "flink\u955c\u50cf\u7684\u7248\u672c"),
    cron("^\\s*($|#|\\w+\\s*=|(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?(?:,(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?)*)\\s+(\\?|\\*|(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?(?:,(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?)*)\\s+(\\?|\\*|(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?(?:,(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?)*|\\?|\\*|(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?(?:,(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?)*)\\s+(\\?|\\*|(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?(?:,(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?)*|\\?|\\*|(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?(?:,(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?)*)(|\\s)+(\\?|\\*|(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?(?:,(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?)*))$", "cron\u8868\u8fbe\u5f0f\u89c4\u5219\u9700\u6ee1\u8db3\u683c\u5f0f"),
    pattern("^\\*|\\+|\\?|\\{(([1-9][0-9]*)|((0|[1-9][0-9]*),)|(,([1-9][0-9]*))|((0|[1-9][0-9]*),([1-9][0-9]*)))\\}|$", "\u5339\u914d\u6a21\u5f0f\uff0c\u5982\uff1a* + ? {n} {n,} {,m} {n,m}"),
    coltype("(?<datatype>[a-zA-Z0-9]+)((\\((?<precision>[0-9]+)){1}(\\,(\\s)*(?<scale>[0-9]+){0,1}){1}\\))?", "\u5217\u7c7b\u578b\u503c\uff0c\u5982\uff1aSTRING,DECIMAL(10,2)"),
    jdbcurl("jdbc:(?<type>[a-z]+)://(?<host>[a-zA-Z0-9-//.]+)(:(?<port>[0-9]+))?(/(?<database>[a-zA-Z0-9_]+))?(\\?(?<params>[?a-zA-Z0-9_=&]+))?", "jdbc\u5730\u5740"),
    no("[\\s\\S]*", "\u4efb\u610f\u5b57\u7b26");

    private final String code;
    private final String message;

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    private StrPattern(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public boolean checkStrFormat(String str) {
        return StrPattern.checkStrFormat(this.code, str);
    }

    public Pattern compile() {
        Pattern pattern = Pattern.compile(this.code);
        return pattern;
    }

    public String[] group(String str, String[] groupNames) {
        return StrPattern.group(this.code, str, groupNames);
    }

    public String[] group(String str) {
        return StrPattern.group(this.code, str, new String[0]);
    }

    public static String[] group(String patternStr, String str, String ... groupNames) {
        if (StringUtil.isNull(str)) {
            return new String[0];
        }
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            if (ArrayUtils.isNotEmpty((Object[])groupNames)) {
                String[] retary = new String[groupNames.length];
                for (int i = 0; i < retary.length; ++i) {
                    try {
                        retary[i] = matcher.group(groupNames[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return retary;
            }
            String[] retary = new String[matcher.groupCount() + 1];
            for (int i = 0; i < retary.length; ++i) {
                retary[i] = matcher.group(i);
            }
            return retary;
        }
        return new String[0];
    }

    public static boolean checkStrFormat(String patternStr, String str) {
        if (StringUtil.isNull(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        boolean bool = matcher.matches();
        return bool;
    }
}

