/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.annotation.TamsCol;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.PageElementOpt;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.lang3.StringUtils;

public enum PageElement implements IEnumCombobox
{
    ValidateBox("\u8f93\u5165\u6846", new PageElementOpt[]{PageElementOpt.missingmsg, PageElementOpt.strpattern}),
    ComboBox("\u4e0b\u62c9\u6846", new PageElementOpt[]{PageElementOpt.enumclass, PageElementOpt.groups, PageElementOpt.url, PageElementOpt.textField, PageElementOpt.valueField, PageElementOpt.multiple, PageElementOpt.parent, PageElementOpt.parentLibs, PageElementOpt.changeHandle, PageElementOpt.mode, PageElementOpt.convertIgnore}),
    CheckBox("\u590d\u9009\u6846", new PageElementOpt[0]),
    Calendar("\u65e5\u5386", new PageElementOpt[]{PageElementOpt.dateFmt}),
    NumberBox("\u53f7\u7801\u6846", new PageElementOpt[]{PageElementOpt.missingmsg, PageElementOpt.min, PageElementOpt.max, PageElementOpt.precision, PageElementOpt.groupsplit}),
    NumberIncrement("\u6570\u5b57\u8c03\u6574\u5668", new PageElementOpt[0]),
    ComboGrid("\u8868\u683c\u4e0b\u62c9\u6846", new PageElementOpt[]{PageElementOpt.columns, PageElementOpt.idField, PageElementOpt.panelWidth, PageElementOpt.panelHeight, PageElementOpt.textField, PageElementOpt.url, PageElementOpt.changeHandle, PageElementOpt.convertIgnore}),
    ComboTree("\u7ec4\u5408\u6811", new PageElementOpt[]{PageElementOpt.columns, PageElementOpt.url, PageElementOpt.multiple, PageElementOpt.panelWidth}),
    Upload("\u6587\u4ef6\u4e0a\u4f20\u7ec4\u4ef6\uff08\u652f\u6301\u591a\u6587\u4ef6\uff09", new PageElementOpt[]{PageElementOpt.url}),
    Yaml("yaml\u6587\u4ef6\u7f16\u8f91", new PageElementOpt[0]),
    Sql("sql\u6587\u4ef6\u7f16\u8f91", new PageElementOpt[]{PageElementOpt.tableToColumnsUrl}),
    Propertygrid("\u5c5e\u6027\u7f16\u8f91", new PageElementOpt[]{PageElementOpt.columns, PageElementOpt.showGroup, PageElementOpt.url, PageElementOpt.height, PageElementOpt.toolbar, PageElementOpt.parent, PageElementOpt.parentLibs}),
    PasswordBox("\u5bc6\u7801\u6846", new PageElementOpt[0]);

    private final String desc;
    private final PageElementOpt[] pageEles;

    private PageElement(String desc, PageElementOpt[] pageEles) {
        this.desc = desc;
        this.pageEles = pageEles;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDesc_zh() {
        return this.desc;
    }

    @Override
    public String getDesc_en() {
        return this.name();
    }

    private Map<PageElementOpt, String> findOpt(JSONObject optJson) {
        HashMap<PageElementOpt, String> retmap = new HashMap<PageElementOpt, String>();
        for (PageElementOpt pageElementOpt : this.pageEles) {
            if (pageElementOpt == PageElementOpt.enumclass && "net.wicp.tams.common.constant.dic.intf.IEnumCombobox".equals(optJson.getString(pageElementOpt.name()))) continue;
            if (optJson.containsKey((Object)pageElementOpt.name()) || StringUtil.isNotNull(optJson.getString(pageElementOpt.name()))) {
                retmap.put(pageElementOpt, optJson.getString(pageElementOpt.name()));
                continue;
            }
            retmap.put(pageElementOpt, pageElementOpt.getDefaultValue());
        }
        return retmap;
    }

    public Map<PageElementOpt, String> findOpt(TamsCol tamsCol) {
        String[] notObjectMethods = ReflectAssist.getNotObjectMethods(tamsCol.getClass());
        JSONObject retjson = new JSONObject();
        for (String notObjectMethod : notObjectMethods) {
            if (!notObjectMethod.startsWith("opt_")) continue;
            String methodname = notObjectMethod.replace("opt_", "");
            String value = PageElementOpt.valueOf(methodname).getConvertValue().getStr(ReflectAssist.invokeMothed(tamsCol, notObjectMethod, new Object[0]));
            retjson.put(methodname, (Object)value);
        }
        if (StringUtil.isNotNull(tamsCol.pageElementOpt())) {
            try {
                JSONObject eleoptJson = JSONObject.parseObject((String)tamsCol.pageElementOpt(), (Feature[])new Feature[]{Feature.AllowSingleQuotes});
                retjson = JSONUtil.mergeJSON(retjson, eleoptJson);
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime(ExceptAll.project_nosupport, "\u5143\u7d20\u3010" + tamsCol.value() + "\u3011\u7684opt\u4e0d\u662fjson\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u5e76\u4fee\u6539", e);
            }
        }
        if ("\u8868\u7684\u91cd\u8981\u6027".equals(tamsCol.value())) {
            System.out.println();
        }
        return this.findOpt(retjson);
    }

    public static PageElement find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return ValidateBox;
        }
        for (PageElement ele : PageElement.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return ValidateBox;
    }
}

