/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import org.apache.commons.lang3.ArrayUtils;

public enum DateFormatCase implements IEnumCombobox
{
    YYYY_MM_DD("yyyy-MM-dd", StrPattern.date),
    YYYY_MM_DD_hhmmss("yyyy-MM-dd HH:mm:ss", StrPattern.date_time),
    YYYY_MM_DD_hhmmssSSS("yyyy-MM-dd HH:mm:ss.SSS", StrPattern.date_time_SSS),
    YYYYMMDD("yyyyMMdd", StrPattern.date2),
    yyyyMMddHHmmss("yyyyMMddHHmmss", StrPattern.date_time2),
    yyyyMMddHHmmssSSS("yyyyMMddHHmmssSSS", StrPattern.date_time_SSS2),
    TyyyyMMddHHmmss("yyyy-MM-dd'T'HH:mm:ssz", StrPattern.date_time_t3),
    TZyyyyMMddHHmmss("yyyy-MM-dd'T'HH:mm:ss'Z'", StrPattern.date_time_t2),
    TyyyyMMddHHmmssNoZ("yyyy-MM-dd'T'HH:mm:ss", StrPattern.date_time_t1),
    TyyyyMMddHHmmssNoZSSS("yyyy-MM-dd'T'HH:mm:ss.SSS", StrPattern.date_time_t12),
    TyyyyMMddHHmmNoZ("yyyy-MM-dd'T'HH:mm", StrPattern.date_time_t13);

    private final String pattern;
    private final StrPattern valuePattern;
    private static String[] excludes;

    public String getPattern() {
        return this.pattern;
    }

    public StrPattern getValuePattern() {
        return this.valuePattern;
    }

    private DateFormatCase(String pattern, StrPattern valuePattern) {
        this.pattern = pattern;
        this.valuePattern = valuePattern;
    }

    public SimpleDateFormat getInstanc() {
        SimpleDateFormat instanc = new SimpleDateFormat(this.pattern);
        return instanc;
    }

    public boolean validDateStr(String datestr) {
        if (this.valuePattern == null) {
            return false;
        }
        return this.valuePattern.checkStrFormat(datestr);
    }

    public static DateFormatCase validDateFormat(String datestr) {
        for (DateFormatCase dateFormatCase : DateFormatCase.values()) {
            if (!dateFormatCase.validDateStr(datestr)) continue;
            return dateFormatCase;
        }
        return null;
    }

    public static DateFormatCase find(String dateformatstr) {
        if (StringUtil.isNull(dateformatstr)) {
            return YYYY_MM_DD;
        }
        for (DateFormatCase dateFormatCase : DateFormatCase.values()) {
            if (!dateFormatCase.getPattern().equalsIgnoreCase(dateformatstr)) continue;
            return dateFormatCase;
        }
        return YYYY_MM_DD;
    }

    public static Date toDate(String datestr) throws ProjectException {
        Date retobj;
        if (ArrayUtils.contains((Object[])excludes, (Object)datestr)) {
            return new Date(0L);
        }
        DateFormatCase validDateFormat = DateFormatCase.validDateFormat(datestr);
        if (validDateFormat == null) {
            throw new ProjectException((IExcept)ExceptAll.project_nosupport, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b");
        }
        switch (validDateFormat) {
            case YYYY_MM_DD_hhmmssSSS: {
                try {
                    String[] group = validDateFormat.getValuePattern().group(datestr);
                    datestr = group[24].length() <= 3 ? datestr : datestr.substring(0, 23);
                    retobj = validDateFormat.getInstanc().parse(datestr);
                    break;
                }
                catch (ParseException e) {
                    throw new ProjectException((IExcept)ExceptAll.project_formatnofit, (Throwable)e);
                }
            }
            case yyyyMMddHHmmssSSS: {
                try {
                    String[] group = validDateFormat.getValuePattern().group(datestr);
                    datestr = group[18].length() <= 3 ? datestr : datestr.substring(0, 17);
                    retobj = validDateFormat.getInstanc().parse(datestr);
                    break;
                }
                catch (ParseException e) {
                    throw new ProjectException((IExcept)ExceptAll.project_formatnofit, (Throwable)e);
                }
            }
            case TyyyyMMddHHmmssNoZSSS: {
                try {
                    String[] group = validDateFormat.getValuePattern().group(datestr);
                    String proStr = StringUtil.proStr("S", group[24].length());
                    retobj = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss." + proStr).parse(datestr);
                    break;
                }
                catch (ParseException e) {
                    throw new ProjectException((IExcept)ExceptAll.project_formatnofit, (Throwable)e);
                }
            }
            default: {
                try {
                    retobj = validDateFormat.getInstanc().parse(datestr);
                    break;
                }
                catch (ParseException e) {
                    throw new ProjectException((IExcept)ExceptAll.project_formatnofit, (Throwable)e);
                }
            }
        }
        return retobj;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDesc() {
        return this.pattern;
    }

    @Override
    public String getDesc_en() {
        return this.pattern;
    }

    @Override
    public String getDesc_zh() {
        return this.pattern;
    }

    static {
        excludes = new String[]{"0001-01-01 00:00:00", "0000-00-00 00:00:00", "00010101000000", "1970-01-01 00:00:00", "19700101000000", "1970-01-01 08:00:00", "19700101080000"};
    }
}

