/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.callback.impl.dbtbconvert;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.constant.DrdsPattern;
import org.apache.commons.lang3.tuple.Pair;

public class DbTbConvertOds
implements IDbTbConvert {
    private final int maxlength;
    private final String tbPre;
    private final DrdsPattern drdsPattern;

    public DrdsPattern getDrdsPattern() {
        return this.drdsPattern;
    }

    public DbTbConvertOds() {
        this.maxlength = 64;
        this.tbPre = "ods";
        this.drdsPattern = DrdsPattern.no;
    }

    public DbTbConvertOds(int maxlength, DrdsPattern drdsPattern) {
        this.maxlength = maxlength;
        this.tbPre = "ods";
        this.drdsPattern = drdsPattern;
    }

    public DbTbConvertOds(String tbPre, DrdsPattern drdsPattern) {
        this.tbPre = tbPre;
        this.maxlength = 64;
        this.drdsPattern = drdsPattern;
    }

    @Override
    public Pair<String, String> getDbAndTb(String region, Pair<String, String> keyObj) {
        String dbstr = ((String)keyObj.getLeft()).toLowerCase();
        dbstr = dbstr.replace("-", "_");
        String tbstr = ((String)keyObj.getRight()).toLowerCase();
        String targetTbName = this.drdsPattern.getTargetTb(this.tbPre, (Pair<String, String>)Pair.of((Object)dbstr, (Object)(tbstr = tbstr.replace("-", "_"))));
        if (targetTbName.length() > this.maxlength) {
            int buildPort = StringUtil.buildPort(targetTbName);
            targetTbName = String.format("%s_%s", targetTbName.substring(0, this.maxlength - 6), buildPort);
        }
        return Pair.of((Object)region, (Object)targetTbName);
    }
}

