/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.thread.threadlocal.PerThreadValue;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertValueEasyUIGrid
implements IConvertValue<String> {
    private static final Logger log = LoggerFactory.getLogger(ConvertValueEasyUIGrid.class);
    private final String url;
    private final boolean cache;
    private final String idfield;
    private final String textfield;
    private JSONObject jsonObject;

    public ConvertValueEasyUIGrid(String url, String idfield, String textfield, boolean cache, Map<String, String> urlContext) {
        String urlTrue = url;
        if (MapUtils.isNotEmpty(urlContext)) {
            for (String contextKey : urlContext.keySet()) {
                urlTrue = urlTrue.replace(String.format("${%s}", contextKey), StringUtil.hasNull(urlContext.get(contextKey)));
            }
        }
        if (!StrPattern.weburl.checkStrFormat(urlTrue)) {
            String context = Conf.get("common.apiext.context");
            log.info("\u540e\u7aef\u4f7f\u7528\u7684context\u4e3a\uff1a{}", (Object)context);
            String string = urlTrue = StringUtil.isNull(context) ? urlTrue : IOUtil.mergeFolderAndFilePath(context, new String[]{urlTrue});
        }
        if (cache) {
            try {
                JSONObject jsonObject;
                this.jsonObject = jsonObject = JSON.parseObject((String)ConvertValueEasyUIGrid.callUrlByTenant(urlTrue));
            }
            catch (Throwable e) {
                this.jsonObject = null;
            }
        } else {
            this.jsonObject = null;
        }
        this.url = urlTrue;
        this.cache = cache;
        this.idfield = idfield;
        this.textfield = textfield;
    }

    public ConvertValueEasyUIGrid(String url, Map<String, String> urlContext) {
        this(url, "id", "name", false, urlContext);
    }

    public ConvertValueEasyUIGrid(String url, String textfield, Map<String, String> urlContext) {
        this(url, "id", textfield, false, urlContext);
    }

    @Override
    public String getStr(String keyObj) {
        if (StringUtil.isNull(keyObj)) {
            return "";
        }
        try {
            JSONObject tempObjs = this.jsonObject;
            if (tempObjs == null) {
                tempObjs = JSON.parseObject((String)ConvertValueEasyUIGrid.callUrlByTenant(this.url));
                if (this.cache) {
                    this.jsonObject = tempObjs;
                }
            }
            JSONArray array = tempObjs.getJSONArray("rows");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                if (!keyObj.equals(jsonObject.getString(this.idfield))) continue;
                return jsonObject.getString(this.textfield);
            }
            return keyObj;
        }
        catch (Throwable e) {
            return keyObj;
        }
    }

    public static String callUrlByTenant(String url) {
        PerThreadValue<String> value;
        String[] head = null;
        Map<String, String> querymap = Conf.getPre("common.jdbc.sqlIntercept.colnameQuery", true);
        if (MapUtils.isNotEmpty(querymap) && querymap.containsKey("tenant_id") && (value = PerthreadManager.getInstance().createValue((Object)querymap.get("tenant_id"), String.class)).exists() && StringUtil.isNotNull(value.get())) {
            head = new String[]{"tenant_id", value.get()};
        }
        String result = IOUtil.doPostOrGet(url, "", head);
        return result;
    }
}

