/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEasyUIGrid;
import net.wicp.tams.common.constant.StrPattern;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertValueEasyUICombobox
implements IConvertValue<String> {
    private static final Logger log = LoggerFactory.getLogger(ConvertValueEasyUICombobox.class);
    private final String url;
    private final boolean cache;
    private JSONArray objs;
    private final String textField;
    private final String valueField;

    public ConvertValueEasyUICombobox(String url, String textField, String valueField, boolean cache, Map<String, String> urlContext) {
        String urlTrue = url;
        if (MapUtils.isNotEmpty(urlContext)) {
            for (String contextKey : urlContext.keySet()) {
                urlTrue = urlTrue.replace(String.format("${%s}", contextKey), urlContext.get(contextKey));
            }
        }
        if (!StrPattern.weburl.checkStrFormat(urlTrue)) {
            String context = Conf.get("common.apiext.context");
            log.info("\u540e\u7aef\u4f7f\u7528\u7684context\u4e3a\uff1a{}", (Object)context);
            String string = urlTrue = StringUtil.isNull(context) ? urlTrue : IOUtil.mergeFolderAndFilePath(context, new String[]{urlTrue});
        }
        if (cache) {
            try {
                JSONArray objs;
                this.objs = objs = JSONArray.parseArray((String)ConvertValueEasyUIGrid.callUrlByTenant(urlTrue));
            }
            catch (Throwable e) {
                this.objs = null;
            }
        } else {
            this.objs = null;
        }
        this.url = urlTrue;
        this.cache = cache;
        this.textField = StringUtil.hasNull(textField, "name");
        this.valueField = StringUtil.hasNull(valueField, "id");
    }

    @Override
    public String getStr(String keyObj) {
        if (StringUtil.isNull(keyObj)) {
            return "";
        }
        try {
            JSONArray tempObjs = this.objs;
            if (tempObjs == null) {
                tempObjs = JSONArray.parseArray((String)ConvertValueEasyUIGrid.callUrlByTenant(this.url));
                if (this.cache) {
                    this.objs = tempObjs;
                }
            }
            for (int i = 0; i < tempObjs.size(); ++i) {
                JSONObject object = tempObjs.getJSONObject(i);
                if (!keyObj.equals(object.getString(this.valueField))) continue;
                return object.getString(this.textField);
            }
            return keyObj;
        }
        catch (Throwable e) {
            return keyObj;
        }
    }
}

