/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.json.serializerconfig;

import com.alibaba.fastjson.serializer.DoubleSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DecimalFormat;

public class DoubleSerializerConfig
extends DoubleSerializer {
    private DecimalFormat decimalFormat = null;

    public DoubleSerializerConfig(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        double doubleValue = (Double)object;
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            out.writeNull();
        } else if (this.decimalFormat == null) {
            out.writeDouble(doubleValue, true);
        } else {
            String doubleText = this.decimalFormat.format(doubleValue);
            out.write("\"" + doubleText + "\"");
        }
    }
}

