/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.ResponseBean;
import net.wicp.tams.common.apiext.json.ResponseInfoBean;
import net.wicp.tams.common.apiext.json.serializerconfig.DoubleSerializerConfig;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEnum;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSONUtil {
    private static final Logger log = LoggerFactory.getLogger(JSONUtil.class);
    public static final String[][] specialChar_globle = new String[][]{{"\\\\", "\\\\\\\\"}, {"\"null\"", "\"\""}};
    public static final String[][] specialChar_value_json = new String[][]{{"\"", "\\\\\""}};

    public static String converJsonStr(String oriStr) {
        if (StringUtil.isNull(oriStr)) {
            return oriStr;
        }
        StringBuffer buff = new StringBuffer();
        block7: for (int i = 0; i < oriStr.length(); ++i) {
            char c = oriStr.charAt(i);
            switch (c) {
                case '\\': {
                    buff.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block7;
                }
                case '\b': {
                    buff.append("\\b");
                    continue block7;
                }
                case '\f': {
                    buff.append("\\f");
                    continue block7;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block7;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }

    public static <T> T getBeanFromJson(Class<T> clazz, JSONObject packParams) {
        try {
            T retobj = clazz.newInstance();
            if (packParams.size() == 0) {
                return retobj;
            }
            for (String key : packParams.keySet()) {
                StringUtil.packObj(retobj, key, packParams.getString(key));
            }
            return retobj;
        }
        catch (Exception e) {
            throw new IllegalAccessError("request\u8f6c\u4e3a\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5f02\u5e38" + e.getMessage());
        }
    }

    public static String getStringByPath(JSONObject obj, String path) {
        if (obj == null && StringUtil.isNotNull(path)) {
            return null;
        }
        String[] split = path.split("\\.", 0);
        String retstr = "";
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                retstr = obj.getString(split[i]);
                continue;
            }
            obj = obj.getJSONObject(split[i]);
        }
        return retstr;
    }

    public static JSONObject getJsonFromUrlStr(String url) {
        String[] params;
        JSONObject retobj = new JSONObject();
        if (StringUtil.isNull(url)) {
            return retobj;
        }
        for (String param : params = url.split("&")) {
            String[] temAry = param.split("=");
            if (temAry.length > 1) {
                retobj.put(temAry[0], (Object)temAry[1]);
                continue;
            }
            retobj.put(temAry[0], (Object)"");
        }
        return retobj;
    }

    public static JSONObject mergeJSON(JSONObject main, JSONObject add) {
        JSONUtil.mergeJSON(main, add, false);
        return main;
    }

    public static JSONObject mergeJSON(JSONObject res1, JSONObject res2, boolean fast) {
        JSONObject addJSON;
        JSONObject jSONObject = fast ? (res1.keySet().size() < res2.keySet().size() ? res1 : res2) : (addJSON = res2);
        JSONObject mainJSON = fast ? (res1.keySet().size() < res2.keySet().size() ? res2 : res1) : res1;
        for (String key : addJSON.keySet()) {
            if (mainJSON.containsKey((Object)key)) {
                try {
                    if (mainJSON.getJSONObject(key).size() <= 0 || addJSON.getJSONObject(key).size() <= 0) continue;
                    JSONUtil.mergeJSON(mainJSON.getJSONObject(key), addJSON.getJSONObject(key), fast);
                }
                catch (Exception e) {
                    mainJSON.put(key, addJSON.get((Object)key));
                }
                continue;
            }
            mainJSON.put(key, addJSON.get((Object)key));
        }
        return mainJSON;
    }

    public static List<String[]> getValuesListAry(JSONObject jsonObject, String ... excludeKeys) {
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        for (String key : jsonObject.keySet()) {
            if (ArrayUtils.isNotEmpty((Object[])excludeKeys) && ArrayUtils.contains((Object[])excludeKeys, (Object)key)) continue;
            resultList.add(new String[]{key, jsonObject.getString(key)});
        }
        return resultList;
    }

    public static String[] getValues(JSONObject jsonObject, String ... excludeKeys) {
        List<String[]> valuesListAry = JSONUtil.getValuesListAry(jsonObject, excludeKeys);
        String[] retAry = new String[valuesListAry.size() * 2];
        for (int i = 0; i < valuesListAry.size(); ++i) {
            retAry[2 * i] = valuesListAry.get(i)[0];
            retAry[2 * i + 1] = valuesListAry.get(i)[1];
        }
        return retAry;
    }

    public static String getJsonForMap(Map<String, Object> fromMap, IConvertValue[] convert, List<String> jsonColList, List<String> base64ColList, String ... keys) {
        if (fromMap == null || fromMap.size() == 0) {
            return null;
        }
        keys = ArrayUtils.isNotEmpty((Object[])keys) ? keys : (String[])fromMap.keySet().toArray();
        StringBuffer buff = new StringBuffer("{");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String[] keyAry = key.split(",");
            String valCol = StringUtil.trimSpace(keyAry[0]);
            String showCol = StringUtil.trimSpace(keyAry[keyAry.length - 1]);
            Map<String, Object> value = StringUtil.isNull(valCol) ? fromMap : fromMap.get(valCol);
            String valueTrue = "";
            if (convert != null && convert.length > i && convert[i] != null) {
                IConvertValue convertTrue = convert[i];
                valueTrue = value == null ? "" : convertTrue.getStr(value);
            } else {
                String string = valueTrue = StringUtil.isNull(valCol) ? "" : String.valueOf(value);
            }
            if (i != 0) {
                buff.append(",");
            }
            if (CollectionUtils.isNotEmpty(jsonColList) && jsonColList.contains(valCol)) {
                JSONObject object = JSON.parseObject((String)valueTrue);
                valueTrue = JSONObject.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes});
            } else if (CollectionUtils.isNotEmpty(base64ColList) && base64ColList.contains(valCol)) {
                valueTrue = PwdUtil.StringToBase64(valueTrue);
            }
            buff.append("\"" + showCol + "\":\"" + StringUtil.hasNull(valueTrue) + "\"");
        }
        buff.append("}");
        return buff.toString();
    }

    public static String getJsonForMap(Map<String, Object> fromMap, String ... keys) {
        return JSONUtil.getJsonForMap(fromMap, null, null, null, keys);
    }

    public static <T> String getJsonForPoJo(T fromobj, IConvertValue[] convert, List<String> jsonColList, List<String> base64ColList, String ... keys) {
        if (fromobj == null) {
            return null;
        }
        List<String> fildes = ReflectAssist.findGetField(fromobj.getClass());
        keys = ArrayUtils.isNotEmpty((Object[])keys) ? keys : fildes.toArray(new String[fildes.size()]);
        StringBuffer buff = new StringBuffer("{");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String[] keyAry = key.split(",");
            String valCol = StringUtil.trimSpace(keyAry[0]);
            String showCol = StringUtil.trimSpace(keyAry[keyAry.length - 1]);
            Object value = null;
            try {
                value = StringUtil.isNull(valCol) ? fromobj : BeanUtils.getProperty(fromobj, (String)valCol);
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a" + valCol);
            }
            String valueTrue = "";
            if (convert != null && convert.length > i && convert[i] != null) {
                IConvertValue convertTrue = convert[i];
                valueTrue = value == null ? "" : convertTrue.getStr(value);
            } else {
                String string = valueTrue = StringUtil.isNull(valCol) ? "" : String.valueOf(value);
            }
            if (i != 0) {
                buff.append(",");
            }
            if (CollectionUtils.isNotEmpty(jsonColList) && jsonColList.contains(valCol)) {
                JSONObject object = JSON.parseObject((String)valueTrue);
                valueTrue = JSONObject.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes});
            } else if (CollectionUtils.isNotEmpty(base64ColList) && base64ColList.contains(valCol)) {
                valueTrue = PwdUtil.StringToBase64(valueTrue);
            }
            buff.append("\"" + showCol + "\":\"" + StringUtil.hasNull(valueTrue) + "\"");
        }
        buff.append("}");
        return buff.toString();
    }

    public static String getJsonForPoJo(Map<String, Object> fromMap, String ... keys) {
        return JSONUtil.getJsonForPoJo(fromMap, null, null, null, keys);
    }

    public static JSONObject getJsonForMapFlat(Map<String, Object> fromMap) {
        JSONObject retobj = new JSONObject();
        if (MapUtils.isEmpty(fromMap)) {
            return retobj;
        }
        for (String key : fromMap.keySet()) {
            String firstkey;
            int spiltIndex = key.indexOf(".");
            String string = firstkey = spiltIndex == -1 ? key : key.substring(0, spiltIndex);
            if (spiltIndex == -1) {
                retobj.put(firstkey, fromMap.get(firstkey));
                continue;
            }
            JSONObject temp = new JSONObject();
            JSONUtil.packJson(temp, key, fromMap.get(key));
            JSONUtil.mergeJSON(retobj, temp, false);
        }
        return retobj;
    }

    private static void packJson(JSONObject retobj, String key, Object value) {
        int spiltIndex = key.indexOf(".");
        if (spiltIndex == -1) {
            retobj.put(key, value);
        } else {
            String firstkey = key.substring(0, spiltIndex);
            JSONObject temp = retobj.containsKey((Object)firstkey) ? retobj.getJSONObject(firstkey) : new JSONObject();
            retobj.put(firstkey, (Object)temp);
            String keyNext = key.substring(spiltIndex + 1);
            JSONUtil.packJson(temp, keyNext, value);
        }
    }

    public static String getJsonForMap(Map fromMap) {
        String str = JSON.toJSONString((Object)fromMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        return str;
    }

    public static String getJsonForList(Collection<IEnumCombobox> fromList) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        JSONArray array = new JSONArray();
        for (IEnumCombobox enumCombobox : fromList) {
            array.add(JSONObject.parse((String)String.format("{\"text\":\"%s\",\"value\":\"%s\"}", enumCombobox.getDesc(), enumCombobox.getName())));
        }
        return array.toJSONString();
    }

    public static String getJsonForList(Collection<?> fromList, IConvertValue<String>[] converts, List<String> jsonCols, List<String> base64Cols, String ... titles) {
        if (CollectionUtils.isEmpty(fromList) || ArrayUtils.isEmpty((Object[])titles)) {
            return "[]";
        }
        StringBuffer buff = new StringBuffer("[");
        for (Object object : fromList) {
            String singJoson;
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                singJoson = JSONUtil.getJsonForMap((Map<String, Object>)((Map)object), converts, jsonCols, base64Cols, titles);
                buff.append(singJoson + ",");
                continue;
            }
            if (CollectionUtils.isNotEmpty(jsonCols) || CollectionUtils.isNotEmpty(base64Cols)) {
                singJoson = JSONUtil.getJsonForPoJo(object, converts, jsonCols, base64Cols, titles);
                buff.append(singJoson + ",");
                continue;
            }
            StringBuffer jsonTempStr = new StringBuffer("@{'{");
            for (int i = 0; i < titles.length; ++i) {
                String[] titleAry = titles[i].split(",");
                String valCol = StringUtil.trimSpace(titleAry[0]);
                String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
                if (StringUtil.isNull(valCol)) {
                    jsonTempStr.append("\"" + showCol + "\":\"\"");
                } else {
                    jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
                }
                if (i == titles.length - 1) continue;
                jsonTempStr.append(",");
            }
            jsonTempStr.append("}'}");
            String tempStr = String.valueOf(TemplateRuntime.eval((String)jsonTempStr.toString(), object));
            tempStr = JSONUtil.converJsonStr(tempStr);
            if (ArrayUtils.isNotEmpty((Object[])converts)) {
                JSONObject jsObj = JSONObject.parseObject((String)tempStr);
                for (int i = 0; i < converts.length; ++i) {
                    String colName;
                    IConvertValue<String> convert = converts[i];
                    String string = colName = i < titles.length ? titles[i] : null;
                    if (convert == null || !StringUtils.isNotBlank((CharSequence)colName)) continue;
                    int index = colName.indexOf(",");
                    String key = "";
                    key = index >= 0 ? colName.substring(index + 1) : colName;
                    String value = index == 0 ? convert.getStr((String)object) : convert.getStr(jsObj.getString(key));
                    jsObj.put(key, (Object)value);
                }
                tempStr = jsObj.toString();
            }
            for (int i = 0; i < specialChar_globle.length; ++i) {
                String[] tempAry = specialChar_globle[i];
                tempStr = tempStr.replaceAll(tempAry[0], tempAry[1]);
            }
            buff.append(tempStr + ",");
        }
        buff.delete(buff.length() - 1, buff.length());
        buff.append("]");
        return buff.toString();
    }

    public static String getJsonForListJsonCol(Collection<?> fromList, List<String> jsonCols, List<String> base64Cols, String ... titles) {
        return JSONUtil.getJsonForList(fromList, new IConvertValue[0], jsonCols, base64Cols, titles);
    }

    public static String getJsonForListJsonCol(Collection<?> fromList, String ... titles) {
        return JSONUtil.getJsonForListJsonCol(fromList, Collections.EMPTY_LIST, Collections.EMPTY_LIST, titles);
    }

    public static String getJsonForListSimple(Collection<?> fromList) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        JSONArray array = new JSONArray();
        for (Object object : fromList) {
            String v = String.valueOf(object);
            array.add(JSONObject.parse((String)String.format("{\"text\":\"%s\",\"value\":\"%s\"}", v, v)));
        }
        return array.toJSONString();
    }

    public static String getJsonForListEmpty() {
        return "[]";
    }

    public static String getJsonForCombobox(Collection<?> fromList, boolean nameByColName, String valueColName, String ... textColNames) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        JSONArray array = new JSONArray();
        for (Object object : fromList) {
            try {
                String value = BeanUtils.getProperty(object, (String)valueColName);
                String text = null;
                for (String textColName : textColNames) {
                    text = text == null ? BeanUtils.getProperty(object, (String)textColName) : text + String.format("\u3010%s\u3011", BeanUtils.getProperty(object, (String)textColName));
                }
                String textColName = textColNames[0];
                if (textColName.equals(valueColName)) {
                    textColName = textColName + "_";
                }
                array.add(JSONObject.parse((String)String.format("{\"%s\":\"%s\",\"%s\":\"%s\"}", nameByColName ? textColName : "text", text, nameByColName ? valueColName : "value", value)));
            }
            catch (Exception e) {
                log.error("\u89e3\u6790text\u548cvalue\u5931\u8d25", (Throwable)e);
            }
        }
        return array.toJSONString();
    }

    public static String getJsonForCombobox(Collection<?> fromList, String colName, boolean nameByColName) {
        return JSONUtil.getJsonForCombobox(fromList, nameByColName, colName, colName);
    }

    public static String getJsonForList(List<?> fromList, Map<String, IConvertValue<String>> convertsMap, List<String> jsonCols, List<String> base64Cols, String ... titles) {
        IConvertValue[] convert = null;
        if (convertsMap != null && CollectionUtils.isNotEmpty(convertsMap.keySet())) {
            convert = new IConvertValue[titles.length];
            for (String title : convertsMap.keySet()) {
                int index = -1;
                for (int i = 0; i < titles.length; ++i) {
                    String trueKey;
                    String eleTitle = titles[i];
                    if (!StringUtils.isNotBlank((CharSequence)eleTitle)) continue;
                    String[] tempTitleAry = eleTitle.split(",");
                    String string = trueKey = tempTitleAry.length > 1 ? tempTitleAry[1] : tempTitleAry[0];
                    if (!title.equalsIgnoreCase(trueKey)) continue;
                    index = i;
                    break;
                }
                if (index < 0) continue;
                convert[index] = convertsMap.get(title);
            }
        }
        return JSONUtil.getJsonForList(fromList, convert, jsonCols, base64Cols, titles);
    }

    public static String getJsonForListAlias(List<?> fromList, String[] aliasTitles, List<String> jsonCols, List<String> base64Cols, Map<String, IConvertValue<String>> convertsMap) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        Object object = fromList.get(0);
        String[] titles = null;
        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
            Map temp = (Map)object;
            titles = new String[temp.size()];
            int i = 0;
            for (Object keyObj : temp.keySet()) {
                titles[i++] = String.valueOf(keyObj);
            }
        } else {
            List<String> fields = ReflectAssist.findGetField(object.getClass());
            titles = fields.toArray(new String[fields.size()]);
        }
        if (aliasTitles != null && aliasTitles.length > 0) {
            titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles, false);
        }
        return JSONUtil.getJsonForList(fromList, convertsMap, jsonCols, base64Cols, titles);
    }

    public static String getJsonForListAlias(List<?> fromList) {
        return JSONUtil.getJsonForListAlias(fromList, null, null, null, null);
    }

    public static String formateJson(String jsonstr) {
        try {
            JSONObject obj = JSONObject.parseObject((String)jsonstr);
            return obj.toJSONString();
        }
        catch (Exception e) {
            return StringUtil.trimSpace(jsonstr);
        }
    }

    public static JSONObject packParams(Object ... params) {
        JSONObject ret = new JSONObject();
        if (ArrayUtils.isEmpty((Object[])params) || params.length < 2) {
            return ret;
        }
        for (int i = 0; i < params.length / 2; ++i) {
            Object key = params[2 * i];
            Object value = 2 * i + 1 < params.length ? params[2 * i + 1] : null;
            ret.put(String.valueOf(key), value);
        }
        return ret;
    }

    public static JSONArray packAry(Object ... arys) {
        JSONArray ret = new JSONArray();
        if (ArrayUtils.isEmpty((Object[])arys)) {
            return ret;
        }
        for (Object ary : arys) {
            ret.add(ary);
        }
        return ret;
    }

    public static JSONArray packAry(String ... arys) {
        JSONArray ret = new JSONArray();
        if (ArrayUtils.isEmpty((Object[])arys)) {
            return ret;
        }
        for (String ary : arys) {
            ret.add((Object)ary);
        }
        return ret;
    }

    public static JSONObject setResult(Result result) {
        JSONObject retjson = new JSONObject();
        if (result.isSuc()) {
            retjson.put("errorValue", (Object)1000);
            retjson.put("errorDesc", (Object)"OK");
            retjson.put("errorCode", (Object)"no");
            retjson.put("http", (Object)"200");
        } else {
            IExcept iExcept = result.getExcept();
            retjson.put("errorValue", (Object)iExcept.getErrorValue());
            retjson.put("errorDesc", (Object)iExcept.getErrMsg());
            retjson.put("errorCode", (Object)iExcept.getErrorCode());
            retjson.put("http", (Object)iExcept.getHttp());
        }
        return retjson;
    }

    public static ResponseBean convertResponBean(JSONObject json) {
        ResponseBean retobj = new ResponseBean();
        retobj.setErrMsg(json.getString("errMsg"));
        json.remove((Object)"errMsg");
        retobj.setErrorCode(json.getString("errorCode"));
        json.remove((Object)"errorCode");
        retobj.setErrorDesc(json.getString("errorDesc"));
        json.remove((Object)"errorDesc");
        retobj.setErrorValue(json.getString("errorValue"));
        json.remove((Object)"errorValue");
        retobj.setHttp(json.getString("http"));
        json.remove((Object)"http");
        ResponseInfoBean responseInfoBean = new ResponseInfoBean();
        JSONObject oriObj = json.getJSONObject("respInfo");
        responseInfoBean.setMsgId(oriObj.getString("msgId"));
        responseInfoBean.setMsgIdResp(oriObj.getString("msgIdResp"));
        responseInfoBean.setReceiptApplication(oriObj.getString("receiptApplication"));
        responseInfoBean.setReceiptSystem(oriObj.getString("receiptSystem"));
        retobj.setRespInfo(responseInfoBean);
        json.remove((Object)"respInfo");
        retobj.setBusiJson(json);
        return retobj;
    }

    public static String toJSONStringForDouble(Object object) {
        SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
        tamsSerializeConfig.put(Double.class, (ObjectSerializer)new DoubleSerializerConfig(new DecimalFormat("0.00")));
        return JSONObject.toJSONString((Object)object, (SerializeConfig)tamsSerializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Map<String, Object> jsonToMap(JSONObject json, String pre) {
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        if (json == null) {
            return retmap;
        }
        String prestr = StringUtil.trimSpace(StringUtil.hasNull(pre, ""));
        for (String key : json.keySet()) {
            String keytrue = key.startsWith(prestr) ? key : prestr + key;
            retmap.put(keytrue, json.get((Object)key));
        }
        return retmap;
    }

    public static Map<String, String> jsonToMapStr(JSONObject json) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        Map<String, Object> jsonToMap = JSONUtil.jsonToMap(json, null);
        for (String key : jsonToMap.keySet()) {
            retmap.put(key, String.valueOf(jsonToMap.get(key)));
        }
        return retmap;
    }

    public static Map<String, Object> jsonToMap(JSONObject json) {
        return JSONUtil.jsonToMap(json, null);
    }

    public static JSONObject getJsonForObject(Object object) {
        return JSONUtil.getJsonForObject(object, null, null, null, null, null);
    }

    public static JSONObject getJsonForObject(Object object, IConvertValue<String>[] converts, String[] titles, String[] aliasTitles, List<String> jsonColList, List<String> base64ColList) {
        int i;
        if (ArrayUtils.isEmpty((Object[])titles)) {
            List<String> fields = ReflectAssist.findGetField(object.getClass());
            titles = fields.toArray(new String[fields.size()]);
        }
        if (aliasTitles != null && aliasTitles.length > 0) {
            titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles, false);
        }
        String singJoson = null;
        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
            singJoson = JSONUtil.getJsonForMap((Map<String, Object>)((Map)object), converts, jsonColList, base64ColList, titles);
        }
        if (CollectionUtils.isNotEmpty(jsonColList)) {
            singJoson = JSONUtil.getJsonForPoJo(object, converts, jsonColList, base64ColList, titles);
        } else {
            StringBuffer jsonTempStr = new StringBuffer("@{'{");
            for (i = 0; i < titles.length; ++i) {
                String[] titleAry = titles[i].split(",");
                String valCol = StringUtil.trimSpace(titleAry[0]);
                String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
                if (StringUtil.isNull(valCol)) {
                    jsonTempStr.append("\"" + showCol + "\":\"\"");
                } else {
                    jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
                }
                if (i == titles.length - 1) continue;
                jsonTempStr.append(",");
            }
            jsonTempStr.append("}'}");
            singJoson = String.valueOf(TemplateRuntime.eval((String)jsonTempStr.toString(), (Object)object));
            for (i = 0; i < specialChar_globle.length; ++i) {
                String[] tempAry = specialChar_globle[i];
                singJoson = singJoson.replaceAll(tempAry[0], tempAry[1]);
            }
        }
        JSONObject jsObj = JSONObject.parseObject((String)singJoson);
        if (ArrayUtils.isNotEmpty((Object[])converts)) {
            for (i = 0; i < converts.length; ++i) {
                String colName;
                IConvertValue<String> convert = converts[i];
                String string = colName = i < titles.length ? titles[i] : null;
                if (convert == null || !StringUtils.isNotBlank((CharSequence)colName)) continue;
                int index = colName.indexOf(",");
                String key = "";
                key = index >= 0 ? colName.substring(index + 1) : colName;
                String value = index == 0 ? convert.getStr((String)object) : convert.getStr(jsObj.getString(key));
                jsObj.put(key, (Object)value);
            }
        }
        return jsObj;
    }

    public static JSONArray getJsonArrayFromEnum(String enumClass, String lan, final String[] includes, final String[] removes) {
        Class<?> cls = null;
        try {
            cls = Class.forName(enumClass);
        }
        catch (ClassNotFoundException e) {
            log.error("\u7c7b\u52a0\u8f7d\u9519\u8bef");
            return null;
        }
        Object[] objs = cls.getEnumConstants();
        if (ArrayUtils.isEmpty((Object[])objs)) {
            return JSONArray.parseArray((String)"[]");
        }
        List list = Arrays.asList(objs);
        if (ArrayUtils.isNotEmpty((Object[])includes)) {
            list = (List)CollectionUtils.select(list, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Enum temobj = (Enum)object;
                    return ArrayUtils.contains((Object[])includes, (Object)temobj.name());
                }
            });
        }
        if (ArrayUtils.isNotEmpty((Object[])removes)) {
            CollectionUtils.filter((Collection)list, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Enum temobj = (Enum)object;
                    return !ArrayUtils.contains((Object[])removes, (Object)temobj.name());
                }
            });
        }
        String filedName = StringUtil.isNull(lan) ? "desc" : String.format("desc_%s", lan);
        ConvertValueEnum cv = new ConvertValueEnum(list.toArray(), lan);
        String curData = JSONUtil.getJsonForList(list, new IConvertValue[]{null, cv}, null, null, "name,", filedName + ",text");
        return JSONArray.parseArray((String)curData);
    }

    public static JSONArray getJsonArrayFromEnum(String enumClass) {
        return JSONUtil.getJsonArrayFromEnum(enumClass, null, null, null);
    }

    public static String convertJsonValue(String oriStr) {
        String retStr = oriStr;
        for (String[] specialChar : specialChar_value_json) {
            retStr = retStr.replace(specialChar[0], specialChar[1]);
        }
        return retStr;
    }

    public static String getDecodeJSONStr(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String StringDanYinToJSON(String ors) {
        ors = ors == null ? "" : ors;
        StringBuilder buffer = new StringBuilder(ors);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == '\'' || buffer.charAt(i) == '\\') {
                buffer.insert(i, '\\');
                i += 2;
                continue;
            }
            ++i;
        }
        return buffer.toString();
    }
}

