/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import com.google.protobuf.ProtocolStringList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.exception.ExceptAll;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlServerAssit {
    private static final Logger log = LoggerFactory.getLogger(SqlServerAssit.class);

    public static String[][] getCols(Connection conn, String db, String tb) {
        try {
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type   from  " + db + ".information_schema.columns  where  table_catalog=? and table_schema='dbo' and table_name=? order by ORDINAL_POSITION");
            ArrayList<String> ret = new ArrayList<String>();
            ArrayList<String> retType = new ArrayList<String>();
            JdbcAssit.setPreParam(prepCols, null, true, db, tb);
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
                retType.add(rs.getString(2));
            }
            rs.close();
            if (CollectionUtils.isEmpty(ret)) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u6570\u636e\u4e3a\u5e93\u5b58\u5728\u5e93\u540d\uff1a[" + db + "],\u8868\u540d\uff1a[" + tb + "]");
            }
            String[][] retAry = new String[2][ret.size()];
            retAry[0] = ret.toArray(new String[ret.size()]);
            retAry[1] = retType.toArray(new String[retType.size()]);
            return retAry;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
    }

    public static Result dataChange(Connection conn, JdbcDatas datas, boolean logicDel) {
        if (datas.getOptType() == OptType.delete && !logicDel) {
            return MySqlAssit.dataDelete(conn, datas);
        }
        return SqlServerAssit.dataUpset(conn, datas, false);
    }

    public static Result dataUpset(Connection conn, JdbcDatas datas, boolean batch) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        Date mindate = null;
        try {
            mindate = DateFormatCase.YYYY_MM_DD.getInstanc().parse("1753-01-01");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getColsCount()];
            for (int j = 0; j < datas.getColsCount(); ++j) {
                Date tempdate;
                String value = jdbcData.getValueMap().get(datas.getCols(j));
                if (value == null) {
                    datasInput[i][j] = value;
                    continue;
                }
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getCols(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                if (value2 instanceof Date && (tempdate = (Date)value2).before(mindate)) {
                    value2 = mindate;
                }
                datasInput[i][j] = value2;
            }
        }
        Map<String, String> typeMap = datas.getTypeMap();
        ProtocolStringList colsList = datas.getColsList();
        BinlogType[] typeAry = new BinlogType[colsList.size()];
        for (int i = 0; i < typeAry.length; ++i) {
            typeAry[i] = BinlogType.valueOf(typeMap.get(colsList.get(i)));
        }
        return SqlServerAssit.dataUpset(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getColsList().toArray((Object[])new String[datas.getColsCount()]), typeAry, (String[])datas.getKeysList().toArray((Object[])new String[datas.getKeysCount()]), batch);
    }

    public static Result dataUpset(Connection conn, String db, String tb, Object[][] datas, String[] cols, BinlogType[] typeAry, String[] keys, boolean batch) {
        Object[][] priDatas = new Object[datas.length][];
        try {
            String insertsql = "INSERT(" + CollectionUtil.arrayJoin(cols, ",") + ") VALUES(S." + CollectionUtil.arrayJoin(cols, ", S.") + ")";
            StringBuffer updateBuf = new StringBuffer("UPDATE SET ");
            StringBuffer selectBuf = new StringBuffer("SELECT ");
            for (String col : cols) {
                if (!ArrayUtils.contains((Object[])keys, (Object)col)) {
                    updateBuf.append(String.format("T.%s = S.%s,", col, col));
                }
                selectBuf.append(String.format("? AS %s,", col));
            }
            String selectsql = selectBuf.substring(0, selectBuf.length() - 1);
            StringBuffer keyBuf = new StringBuffer();
            for (String key : keys) {
                keyBuf.append(String.format("and T.%s = S.%s ", key, key));
            }
            String keysql = keyBuf.substring(3);
            String updatesql = updateBuf.substring(0, updateBuf.length() - 1);
            String sql = String.format("MERGE INTO %s.dbo.%s as T USING (%s) AS S  ON %s WHEN MATCHED THEN  %s WHEN NOT MATCHED THEN  %s;", db, tb, selectsql, keysql, updatesql, insertsql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            if (batch) {
                conn.setAutoCommit(false);
                stmt.clearBatch();
                for (int i = 0; i < datas.length; ++i) {
                    int indexOf;
                    if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                    JdbcAssit.setPreParam(stmt, typeAry, false, datas[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
            } else {
                conn.setAutoCommit(true);
                for (int i = 0; i < datas.length; ++i) {
                    int indexOf;
                    if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                    JdbcAssit.setPreParam(stmt, typeAry, false, datas[i]);
                    stmt.execute();
                }
            }
            stmt.close();
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d2\u5165\u5931\u8d25", (Throwable)e);
            return new Result(ExceptAll.jdbc_exec_fail);
        }
    }
}

