/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ProtocolStringList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.callback.ICreateDbCallBack;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.DrdsPattern;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.constant.ods.AddColNameType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MySqlAssit
extends JdbcAssit {
    private static final Logger log = LoggerFactory.getLogger(MySqlAssit.class);
    private static String[] tenantIdColname = new String[]{"tenantid", "tenant_id"};
    private static String[] bigColType = new String[]{"longblob", "json", "longtext", "mediumtext", "text", "blob"};

    public static String getColsForQuery(String[] cols) {
        String colsstr = "`" + CollectionUtil.arrayJoin(cols, "`,`") + "`";
        return colsstr;
    }

    public static List<String[]> getAllTables(Connection conn) {
        return MySqlAssit.getAllTables(conn, null, null);
    }

    public static List<String> getAllDbs(Connection conn, String ... excludes) {
        List<Object> querySqlMapPre = new ArrayList();
        querySqlMapPre = MySqlAssit.querySqlMapPre(conn, "show databases", false, new Object[0]);
        ArrayList<String> excluesDbs = new ArrayList<String>();
        excluesDbs.add("mysql");
        if (excludes != null) {
            excluesDbs.addAll(Arrays.asList(excludes));
        }
        ArrayList<String> returlist = new ArrayList<String>();
        for (Map map : querySqlMapPre) {
            String dbName = (String)map.get("Database");
            if (excluesDbs.contains(dbName)) continue;
            returlist.add(dbName);
        }
        return returlist;
    }

    public static String jsonValue(JSONObject json) {
        StringBuffer buff = new StringBuffer("JSON_OBJECT(");
        for (String key : json.keySet()) {
            buff.append(String.format("'%s', '%s'", key, json.get((Object)key)));
        }
        buff.append(")");
        return buff.toString();
    }

    public static String jsonValue(JSONArray jsonArray) {
        StringBuffer buff = new StringBuffer("JSON_ARRAY(");
        for (Object ele : jsonArray) {
            buff.append(String.format("'%s'", String.valueOf(ele)));
        }
        buff.append(")");
        return buff.toString();
    }

    public static List<Map<String, String>> querySqlMap(Connection conn, String sql, int from, int num, boolean isConvertKey) {
        int indexOf = sql.indexOf("limit");
        if (indexOf >= 0) {
            sql = sql.substring(0, indexOf);
        }
        sql = sql + String.format(" limit %s,%s", from, num);
        List<Map<String, String>> querySqlMap = JdbcAssit.querySqlMap(conn, sql, isConvertKey);
        return querySqlMap;
    }

    public static int querySqlCount(Connection conn, String sql) {
        int indexOf = sql.indexOf("limit");
        if (indexOf >= 0) {
            sql = sql.substring(0, indexOf);
        }
        sql = sql.substring(sql.indexOf("from"));
        sql = "select count(1) " + sql;
        ResultSet rs = JdbcAssit.querySql(conn, sql);
        int allnum = -1;
        try {
            allnum = rs.next() ? rs.getInt(1) : 0;
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u603b\u6570\u5931\u8d25", (Throwable)e);
        }
        return allnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllTables(Connection conn, String dbPattern, String tbPattern) {
        String sql = "select  TABLE_SCHEMA,TABLE_NAME from information_schema.tables where 1=1";
        ResultSet rs = JdbcAssit.querySql(conn, sql);
        ArrayList<String[]> retlist = new ArrayList<String[]>();
        String dbPatternTrue = StringUtil.buildRule(StringUtil.trimSpace(dbPattern));
        String tbPatternTrue = StringUtil.buildRule(StringUtil.trimSpace(tbPattern));
        try {
            while (rs.next()) {
                boolean isChecked;
                if (StringUtil.isNotNull(dbPatternTrue) && !"^*$".equals(dbPatternTrue) && !"*".equals(dbPatternTrue) && !(isChecked = StrPattern.checkStrFormat(dbPatternTrue, rs.getString("TABLE_SCHEMA"))) || StringUtil.isNotNull(tbPatternTrue) && !"^*$".equals(tbPatternTrue) && !"*".equals(tbPatternTrue) && !(isChecked = StrPattern.checkStrFormat(tbPatternTrue, rs.getString("TABLE_NAME")))) continue;
                retlist.add(new String[]{rs.getString("TABLE_SCHEMA"), rs.getString("TABLE_NAME")});
            }
        }
        catch (Exception e) {
            log.error("find tables error", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return retlist;
    }

    public static List<List<Pair<String, String>>> getAllTablesSplitGroup(Connection conn, String dbPattern, String tbPattern, DrdsPattern splitPattern) {
        List<String[]> tables = MySqlAssit.getAllTables(conn, dbPattern, tbPattern);
        ArrayList<List<Pair<String, String>>> retlist = new ArrayList<List<Pair<String, String>>>();
        for (String[] table : tables) {
            if (CollectionUtils.isEmpty(retlist)) {
                ArrayList<Pair> temp = new ArrayList<Pair>();
                temp.add(Pair.of((Object)table[0], (Object)table[1]));
                retlist.add(temp);
                continue;
            }
            boolean hasSame = false;
            for (List list : retlist) {
                boolean sameGroup = splitPattern.isSameGroup((Pair<String, String>)((Pair)list.get(0)), (Pair<String, String>)Pair.of((Object)table[0], (Object)table[1]));
                if (!sameGroup) continue;
                list.add(Pair.of((Object)table[0], (Object)table[1]));
                hasSame = true;
                break;
            }
            if (hasSame) continue;
            ArrayList<Pair> temp = new ArrayList<Pair>();
            temp.add(Pair.of((Object)table[0], (Object)table[1]));
            retlist.add(temp);
        }
        return retlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllTables(Connection conn, String dbName) {
        String sql = "select  TABLE_SCHEMA,TABLE_NAME from information_schema.tables where TABLE_SCHEMA=?";
        ResultSet rs = null;
        ArrayList<String[]> retlist = new ArrayList<String[]>();
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            MySqlAssit.setPreParam(stmt, true, dbName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                retlist.add(new String[]{rs.getString("TABLE_SCHEMA"), rs.getString("TABLE_NAME")});
            }
        }
        catch (Exception e) {
            log.error("find tables error", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return retlist;
    }

    public static List<String[]> getAllTablesPattern(Connection conn, String dbName, final String tbPattern) {
        List<String[]> allTables = MySqlAssit.getAllTables(conn, dbName);
        String tbPatternTemp = StringUtil.isNull(tbPattern) ? "*" : tbPattern;
        final String tbPatternTrue = "^" + tbPatternTemp + "$";
        CollectionUtils.filter(allTables, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                if (StringUtil.isNull(tbPattern)) {
                    return true;
                }
                String[] name = (String[])object;
                boolean retdb = StrPattern.checkStrFormat(tbPatternTrue, name[1]);
                return retdb;
            }
        });
        return allTables;
    }

    public static Result dataUpset(Connection conn, String db, String tb, Object[][] datas, String[] cols, BinlogType[] typeAry, boolean batch) {
        Object[][] priDatas = new Object[datas.length][];
        StringBuffer ids = new StringBuffer();
        try {
            Object[] tempAry = new String[cols.length];
            for (int i = 0; i < tempAry.length; ++i) {
                tempAry[i] = "?";
            }
            String sql = String.format("replace into %s.%s (%s) values (%s)", db, tb, MySqlAssit.getColsForQuery(cols), CollectionUtil.arrayJoin(tempAry, ","));
            PreparedStatement stmt = conn.prepareStatement(sql);
            if (batch) {
                conn.setAutoCommit(false);
                stmt.clearBatch();
                for (int i = 0; i < datas.length; ++i) {
                    int indexOf;
                    if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                    ids.append(datas[i][0] + ",");
                    JdbcAssit.setPreParam(stmt, typeAry, false, datas[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
            } else {
                conn.setAutoCommit(true);
                for (int i = 0; i < datas.length; ++i) {
                    int indexOf;
                    if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                    ids.append(datas[i][0] + ",");
                    JdbcAssit.setPreParam(stmt, typeAry, false, datas[i]);
                    stmt.execute();
                }
            }
            stmt.close();
            return Result.getSuc();
        }
        catch (Exception e) {
            String errmsg = String.format("\u6279\u91cf\u63d2\u5165\u5931\u8d25,db\u3010%s\u3011,tb\u3010%s\u3011,ids\u3010%s\u3011", db, tb, ids.toString());
            log.error(errmsg, (Throwable)e);
            return new Result(ExceptAll.jdbc_exec_fail);
        }
    }

    public static Result dataUpset(Connection conn, String db, String tb, List<Map<String, String>> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return Result.getSuc();
        }
        JdbcDatas.Builder dataBuilder = MySqlAssit.createJdbcDataBuilder(conn, db, tb);
        for (Map<String, String> data : datas) {
            JdbcData.Builder jdbcDataBuild = JdbcData.newBuilder();
            jdbcDataBuild.putAllValue(data);
            dataBuilder.addDatas(jdbcDataBuild);
        }
        return MySqlAssit.dataUpset(conn, dataBuilder.build(), true);
    }

    public static JdbcDatas.Builder createJdbcDataBuilder(Connection conn, String db, String tb) {
        JdbcDatas.Builder dataBuilder = JdbcDatas.newBuilder();
        dataBuilder.setDb(db);
        dataBuilder.setTb(tb);
        dataBuilder.setOptType(OptType.update);
        String[] primary = MySqlAssit.getPrimary(conn, db, tb);
        dataBuilder.addAllKeys(Arrays.asList(primary));
        String[][] cols = MySqlAssit.getCols(conn, db, tb, YesOrNo.no);
        dataBuilder.addAllCols(Arrays.asList(cols[0]));
        for (int i = 0; i < cols[0].length; ++i) {
            BinlogType binlogType = BinlogType.getByName(cols[1][i]);
            dataBuilder.putType(cols[0][i], binlogType.name());
        }
        return dataBuilder;
    }

    public static Result dataUpsetV1(Connection conn, JdbcDatas datas, boolean batch) {
        String sql = MySqlAssit.packageBatchSql(datas);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql.toString());
            conn.setAutoCommit(false);
            stmt.execute();
            conn.commit();
        }
        catch (SQLException throwables) {
            throw new ProjectExceptionRuntime(ExceptAll.param_error, "db:[" + datas.getDb() + "],tb:[" + datas.getTb() + "] upset\u6570\u636e\u51fa\u9519:" + throwables.getMessage(), throwables);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
        return Result.getSuc();
    }

    public static String packageBatchSql(JdbcDatas datas) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        StringBuilder sqlValues = new StringBuilder();
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getColsCount()];
            StringBuilder sqlValue = new StringBuilder();
            sqlValue.append("(");
            for (int j = 0; j < datas.getColsCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getCols(j));
                if (value == null) {
                    sqlValue.append(value).append(",");
                    continue;
                }
                value = value.replaceAll("'", "''");
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getCols(j)));
                Object value2 = BinlogType.getValueBuildSql(binlogType, value);
                if (value2 instanceof String) {
                    value2 = StringUtil.filterEmoji((String)value2);
                }
                sqlValue.append(value2).append(",");
            }
            if (sqlValue.length() > 1) {
                sqlValue.deleteCharAt(sqlValue.length() - 1);
                sqlValue.append(")");
            }
            sqlValues.append(sqlValue.toString()).append(",");
        }
        if (sqlValues.length() > 0) {
            sqlValues.deleteCharAt(sqlValues.length() - 1);
        }
        String sql = String.format("replace into %s.%s (%s) values %s", datas.getDb(), datas.getTb(), MySqlAssit.getColsForQuery((String[])datas.getColsList().toArray((Object[])new String[datas.getColsList().size()])), sqlValues.toString());
        return sql;
    }

    public static Result dataUpset(Connection conn, JdbcDatas datas, boolean batch) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getColsCount()];
            for (int j = 0; j < datas.getColsCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getCols(j));
                if (value == null) {
                    datasInput[i][j] = value;
                    continue;
                }
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getCols(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                datasInput[i][j] = value2;
            }
        }
        Map<String, String> typeMap = datas.getTypeMap();
        ProtocolStringList colsList = datas.getColsList();
        BinlogType[] typeAry = new BinlogType[colsList.size()];
        for (int i = 0; i < typeAry.length; ++i) {
            typeAry[i] = BinlogType.valueOf(typeMap.get(colsList.get(i)));
        }
        return MySqlAssit.dataUpset(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getColsList().toArray((Object[])new String[datas.getColsList().size()]), typeAry, batch);
    }

    public static Result dataDelete(Connection conn, String db, String tb, Object[][] datas, String[] keys) {
        if (ArrayUtils.isEmpty((Object[])keys)) {
            keys = MySqlAssit.getPrimary(conn, db, tb);
        }
        if (!ArrayUtils.isEmpty((Object[])keys)) {
            StringBuilder builder = new StringBuilder(String.format("delete from %s.%s where 1=1", db, tb));
            for (String key : keys) {
                builder.append(String.format(" and %s=?", key));
            }
            try {
                conn.setAutoCommit(false);
                PreparedStatement stmtDel = conn.prepareStatement(builder.toString());
                for (int i = 0; i < datas.length; ++i) {
                    JdbcAssit.setPreParam(stmtDel, null, false, datas[i]);
                    stmtDel.addBatch();
                }
                stmtDel.executeBatch();
                conn.commit();
                stmtDel.close();
                return Result.getSuc();
            }
            catch (SQLException e) {
                log.error("\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25", (Throwable)e);
                return new Result(new ProjectException((IExcept)ExceptAll.jdbc_exec_fail, "\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25"));
            }
        }
        throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail);
    }

    public static Result dataDelete(Connection conn, JdbcDatas datas) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getKeysCount()];
            for (int j = 0; j < datas.getKeysCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getKeys(j));
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getKeys(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                datasInput[i][j] = value2;
            }
        }
        return MySqlAssit.dataDelete(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getKeysList().toArray((Object[])new String[datas.getKeysCount()]));
    }

    public static Result dataChange(Connection conn, JdbcDatas datas, boolean logicDel) {
        if (datas.getOptType() == OptType.delete && !logicDel) {
            return MySqlAssit.dataDelete(conn, datas);
        }
        return MySqlAssit.dataUpsetV1(conn, datas, true);
    }

    public static String[] getPrimary(Connection conn, String db, String tb, DbType dbType) {
        String[] keyids = null;
        if (dbType == DbType.doris) {
            List<Map<String, String>> querySqlMap = MySqlAssit.querySqlMap(conn, String.format("show create table %s.%s", db, tb), false);
            String createSql = querySqlMap.get(0).get("Create Table");
            String uk = "UNIQUE KEY";
            String ak = "AGGREGATE KEY";
            int indexBegin = createSql.indexOf(uk);
            keyids = indexBegin == -1 ? MySqlAssit.getkey(createSql, createSql.indexOf(ak), ak) : MySqlAssit.getkey(createSql, indexBegin, uk);
        } else if (dbType == DbType.mysql) {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = conn.prepareStatement("SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING (constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=? AND t.table_name=?");
                JdbcAssit.setPreParam(preparedStatement, null, true, db, tb);
                ResultSet rs2 = preparedStatement.executeQuery();
                if (!rs2.next()) {
                    String[] uk = new String[]{};
                    return uk;
                }
                ArrayList<String> retlist = new ArrayList<String>();
                retlist.add(rs2.getString(1));
                while (rs2.next()) {
                    retlist.add(rs2.getString(1));
                }
                keyids = retlist.toArray(new String[retlist.size()]);
            }
            catch (SQLException e) {
                log.error("\u67e5\u4e3b\u952e\u5931\u8d25");
                throw new ProjectExceptionRuntime(ExceptAll.jdbc_query_primary);
            }
            finally {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception e2) {
                    log.error("\u5173\u95edpreparedStatement\u5931\u8d25", (Throwable)e2);
                }
            }
        }
        return keyids;
    }

    public static String[] getPrimary(Connection conn, String db, String tb) {
        return MySqlAssit.getPrimary(conn, db, tb, DbType.mysql);
    }

    public static String[][] getCols(Connection conn, String db, String tb, YesOrNo isRds) {
        try {
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type   from  information_schema.columns  where  table_schema=? and table_name=? order by ORDINAL_POSITION");
            ArrayList<String> ret = new ArrayList<String>();
            ArrayList<String> retType = new ArrayList<String>();
            JdbcAssit.setPreParam(prepCols, null, true, db, tb);
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
                retType.add(rs.getString(2));
            }
            rs.close();
            if (CollectionUtils.isEmpty(ret)) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u6570\u636e\u4e3a\u5e93\u5b58\u5728\u5e93\u540d\uff1a[" + db + "],\u8868\u540d\uff1a[" + tb + "]");
            }
            if (YesOrNo.yes == isRds && ArrayUtils.isEmpty((Object[])MySqlAssit.getPrimary(conn, db, tb))) {
                ret.add("_rowkey_");
                retType.add("varchar");
            }
            String[][] retAry = new String[2][ret.size()];
            retAry[0] = ret.toArray(new String[ret.size()]);
            retAry[1] = retType.toArray(new String[retType.size()]);
            return retAry;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
    }

    public static BinlogType[] convertColumnType(String[] cosTypes) {
        BinlogType[] rettypes = new BinlogType[cosTypes.length];
        for (int i = 0; i < rettypes.length; ++i) {
            rettypes[i] = BinlogType.getByName(cosTypes[i]);
        }
        return rettypes;
    }

    public static Pair<String[], BinlogType[]> needColAndType(Connection connection, String db, String tb, String[] needcols, String routeCol, String[] primarys) {
        String[][] cols = MySqlAssit.getCols(connection, db, tb, YesOrNo.yes);
        if (StringUtil.isNull(needcols)) {
            return Pair.of((Object)cols[0], (Object)MySqlAssit.convertColumnType(cols[1]));
        }
        String[] retEles = CollectionUtil.arrayAnd(String[].class, cols[0], needcols);
        retEles = CollectionUtil.arrayMerge(String[].class, retEles, primarys, true);
        if (StringUtil.isNotNull(routeCol)) {
            retEles = CollectionUtil.arrayMerge(String[].class, retEles, new String[]{routeCol}, true);
        }
        String[] retTypes = new String[retEles.length];
        for (int k = 0; k < retEles.length; ++k) {
            int index = ArrayUtils.indexOf((Object[])cols[0], (Object)retEles[k]);
            retTypes[k] = cols[1][index];
        }
        return Pair.of((Object)retEles, (Object)MySqlAssit.convertColumnType(retTypes));
    }

    public static List<MySqlColBean> getColsBean(Connection conn, String db) {
        return MySqlAssit.getColsBean(conn, db, null);
    }

    public static List<MySqlColBean> getColsBeanCommon(Connection conn, String db, String tb, DbType dbType) {
        try {
            Validate.notBlank((CharSequence)db, (String)"\u9700\u8981\u4f20\u5165\u6307\u5b9a\u7684\u5e93\u540d\u3002", (Object[])new Object[0]);
            boolean hastb = StringUtil.isNotNull(tb);
            PreparedStatement prepCols = conn.prepareStatement("select   table_schema,table_name,column_name,data_type,column_type,column_comment,numeric_precision,numeric_scale,character_maximum_length,column_key,is_nullable   from  information_schema.columns  where  1=1  and table_schema=?" + (hastb ? " and table_name=?" : "") + " order by ORDINAL_POSITION");
            ArrayList<MySqlColBean> retlist = new ArrayList<MySqlColBean>();
            if (hastb) {
                JdbcAssit.setPreParam(prepCols, null, true, db, tb);
            } else {
                JdbcAssit.setPreParam(prepCols, true, db);
            }
            ResultSet rs = prepCols.executeQuery();
            Object[] keyids = null;
            if (dbType == DbType.doris) {
                keyids = MySqlAssit.getPrimary(conn, db, tb, dbType);
            }
            while (rs.next()) {
                MySqlColBean tempobj = new MySqlColBean();
                tempobj.setDb(rs.getString("table_schema"));
                tempobj.setTb(rs.getString("table_name"));
                tempobj.setColumnComment(rs.getString("column_comment"));
                tempobj.setColumnName(rs.getString("column_name"));
                tempobj.setColumnType(rs.getString("column_type"));
                tempobj.setDataType(rs.getString("data_type"));
                tempobj.setNumericScale(rs.getInt("numeric_scale"));
                tempobj.setNotNull("NO".equalsIgnoreCase(rs.getString("is_nullable")));
                long maxlength = StringUtil.isNull(rs.getString("numeric_precision")) ? rs.getLong("character_maximum_length") : rs.getLong("numeric_precision");
                tempobj.setMaxlength(maxlength);
                if (dbType == DbType.mysql) {
                    tempobj.setPri("PRI".equals(rs.getString("column_key")));
                } else if (dbType == DbType.doris) {
                    boolean iskey = ArrayUtils.contains((Object[])keyids, (Object)rs.getString("column_name"));
                    tempobj.setPri(iskey);
                }
                retlist.add(tempobj);
            }
            rs.close();
            if (CollectionUtils.isEmpty(retlist)) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u6570\u636e\u4e3a\u5e93\u5b58\u5728\u5e93\u540d\uff1a[" + db + "],\u8868\u540d\uff1a[" + tb + "]");
            }
            return retlist;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
    }

    private static String[] getkey(String createSql, int indexBegin, String keytype) {
        int indexEnd = createSql.indexOf(")", indexBegin);
        String keysStr = createSql.substring(indexBegin + keytype.length() + 1, indexEnd);
        keysStr = keysStr.replace(" ", "");
        keysStr = keysStr.replace("`", "");
        return keysStr.split(",");
    }

    public static List<MySqlColBean> getColsBean(Connection conn, String db, String tb) {
        return MySqlAssit.getColsBeanCommon(conn, db, tb, DbType.mysql);
    }

    public static List<MySqlColBean> getColsBeanByDoris(Connection conn, String db, String tb) {
        return MySqlAssit.getColsBeanCommon(conn, db, tb, DbType.doris);
    }

    public static List<MySqlColBean> convertCol(List<MySqlColBean> oriList, FieldFormart fieldFormart, AddColNameType addColNameType) {
        ArrayList<MySqlColBean> retlis = new ArrayList<MySqlColBean>();
        for (MySqlColBean ori : oriList) {
            MySqlColBean mySqlColBean = null;
            try {
                mySqlColBean = (MySqlColBean)ori.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            mySqlColBean.setColumnName(ori.getColumnNameStandard(fieldFormart));
            retlis.add(mySqlColBean);
        }
        if (addColNameType != AddColNameType.no) {
            for (AddColName addColName : AddColName.values()) {
                if ((addColNameType == AddColNameType.selective || addColNameType == AddColNameType.selective_ori) && !addColName.isSetValue()) continue;
                MySqlColBean mySqlColBean = new MySqlColBean();
                mySqlColBean.setColumnComment(addColName.getDesc());
                mySqlColBean.setDataType(addColName.getBinlogType().name());
                mySqlColBean.setColumnName(addColName.getColNameTrue(fieldFormart));
                retlis.add(mySqlColBean);
            }
        }
        return retlis;
    }

    public static List<MySqlColBean> getColsBeanByPattern(Connection conn, final String dbPattern, final String tbPattern) {
        List<String> allDbs = MySqlAssit.getAllDbs(conn, new String[0]);
        String dbPatternTemp = StringUtil.isNull(dbPattern) ? "*" : dbPattern;
        final String dbPatternTrue = "^" + dbPatternTemp + "$";
        String tbPatternTemp = StringUtil.isNull(tbPattern) ? "*" : tbPattern;
        final String tbPatternTrue = "^" + tbPatternTemp + "$";
        CollectionUtils.filter(allDbs, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                if (StringUtil.isNull(dbPattern)) {
                    return true;
                }
                String dbname = String.valueOf(object);
                boolean retdb = StrPattern.checkStrFormat(dbPatternTrue, dbname);
                return retdb;
            }
        });
        ArrayList<MySqlColBean> retlist = new ArrayList<MySqlColBean>();
        for (String db : allDbs) {
            List<MySqlColBean> tbBeans = MySqlAssit.getColsBean(conn, db);
            CollectionUtils.filter(tbBeans, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    if (StringUtil.isNull(tbPattern)) {
                        return true;
                    }
                    MySqlColBean mySqlColBean = (MySqlColBean)object;
                    boolean retdb = StrPattern.checkStrFormat(tbPatternTrue, mySqlColBean.getTb());
                    return retdb;
                }
            });
            retlist.addAll(tbBeans);
        }
        return retlist;
    }

    public static String getTableCreateSQL(List<MySqlColBean> cols, DbType toDbType, ICreateDbCallBack createDbCallBack, List<MySqlColBean> addCols, boolean toLowerCase, boolean needTenantId) {
        List<String> sqlList = MySqlAssit.getTableCreateSQLList(cols, toDbType, createDbCallBack, FieldFormart.dbstandard, addCols, toLowerCase, needTenantId, false);
        StringBuffer allSqlBuf = new StringBuffer();
        for (String sql : sqlList) {
            allSqlBuf.append(sql);
        }
        return allSqlBuf.toString();
    }

    public static String getTableUpdateSQL(String tableName, List<MySqlColBean> cols, ICreateDbCallBack createDbCallBack, boolean isAppend, String ... addColNames) {
        List hasColnames = cols.stream().map(col -> col.getColumnNameStandard(FieldFormart.dbstandard).toLowerCase()).collect(Collectors.toList());
        StringBuffer buff = new StringBuffer();
        for (String addColName : addColNames) {
            if (hasColnames.contains(addColName.toLowerCase())) continue;
            buff.append(String.format(",ADD COLUMN `%s` text %s\n", addColName.toLowerCase(), isAppend ? "" : "REPLACE NULL"));
        }
        if (buff.length() > 0) {
            String addColSql = "alter table %s %s";
            String retstr = String.format(addColSql, tableName, buff.substring(1));
            return retstr;
        }
        return "";
    }

    public static List<String> getTableCreateSQLList(List<MySqlColBean> cols, DbType toDbType, ICreateDbCallBack createDbCallBack, FieldFormart fieldFormart, List<MySqlColBean> addCols, boolean toLowerCase, boolean needTenantId, boolean tenantidIsnotnull) {
        Map<Pair<String, String>, List<MySqlColBean>> colsBytable = MySqlAssit.splitGroupByDbTb(cols, fieldFormart);
        ArrayList<String> retlist = new ArrayList<String>();
        for (Pair<String, String> key : colsBytable.keySet()) {
            String createKeySql;
            StringBuffer allSqlBuf = new StringBuffer();
            List<MySqlColBean> colObjs = colsBytable.get(key);
            Collections.sort(colObjs);
            String dbtbname = String.format("%s.%s", key.getLeft(), key.getRight());
            if (createDbCallBack != null) {
                dbtbname = createDbCallBack.getDbAndTb(key);
            }
            allSqlBuf.append(new StringBuffer("create table IF NOT EXISTS " + dbtbname + "("));
            ArrayList<String> prikeylist = new ArrayList<String>();
            ArrayList<String> colnamelist = new ArrayList<String>();
            ArrayList<String> partlist = new ArrayList<String>();
            ArrayList<MySqlColBean> keyCols = new ArrayList<MySqlColBean>();
            ArrayList<MySqlColBean> nokeyCols = new ArrayList<MySqlColBean>();
            MySqlColBean tenantidCol = null;
            ArrayList<MySqlColBean> bigColNames = new ArrayList<MySqlColBean>();
            for (MySqlColBean colObj : colObjs) {
                if (needTenantId && ArrayUtils.contains((Object[])tenantIdColname, (Object)colObj.getColumnNameStandard(fieldFormart))) {
                    tenantidCol = colObj;
                } else {
                    if (colObj.isPri()) {
                        keyCols.add(colObj);
                    } else {
                        nokeyCols.add(colObj);
                    }
                    if (colObj.isPart()) {
                        partlist.add(colObj.getColumnNameStandard(fieldFormart));
                    }
                }
                if (ArrayUtils.contains((Object[])bigColType, (Object)colObj.getDataType())) {
                    bigColNames.add(colObj);
                }
                colnamelist.add(colObj.getColumnNameStandard(fieldFormart));
            }
            if (tenantidCol != null) {
                allSqlBuf.append(String.format("`%s` %s " + (tenantidIsnotnull ? "not null" : "") + " comment \"_key__\",", tenantidCol.getColumnNameStandard(fieldFormart), createDbCallBack == null ? tenantidCol.getColumnType() : createDbCallBack.getColumnType(tenantidCol, bigColNames)));
            }
            for (MySqlColBean colObj : keyCols) {
                allSqlBuf.append(String.format("`%s` %s not null comment \"_key__\",", colObj.getColumnNameStandard(fieldFormart), createDbCallBack == null ? colObj.getColumnType() : createDbCallBack.getColumnType(colObj, bigColNames)));
                prikeylist.add(colObj.getColumnNameStandard(fieldFormart));
            }
            for (MySqlColBean colObj : nokeyCols) {
                allSqlBuf.append(String.format("`%s` %s REPLACE NULL comment \"%s\",", colObj.getColumnNameStandard(fieldFormart), createDbCallBack == null ? colObj.getColumnType() : createDbCallBack.getColumnType(colObj, bigColNames), StringUtil.hasNull(colObj.getColumnComment())));
            }
            if (CollectionUtils.isNotEmpty(addCols)) {
                for (MySqlColBean addCol : addCols) {
                    if (colnamelist.contains(addCol.getColumnNameStandard(fieldFormart))) continue;
                    colnamelist.add(addCol.getColumnNameStandard(fieldFormart));
                    allSqlBuf.append(String.format("`%s` %s comment \"%s\",", addCol.getColumnNameStandard(fieldFormart), addCol.getColumnType(), StringUtil.hasNull(addCol.getColumnComment())));
                }
            }
            ArrayList<String> prikeylistTrue = new ArrayList<String>();
            prikeylistTrue.addAll(prikeylist);
            if (tenantidCol != null && !prikeylist.contains(tenantidCol.getColumnNameStandard(fieldFormart))) {
                prikeylistTrue.add(tenantidCol.getColumnNameStandard(fieldFormart));
            }
            if (StringUtil.isNull(createKeySql = toDbType.getCreateKeySql(prikeylistTrue))) {
                allSqlBuf.deleteCharAt(allSqlBuf.length() - 1);
            } else {
                allSqlBuf.append(createKeySql);
            }
            allSqlBuf.append(")");
            if (createDbCallBack != null) {
                allSqlBuf.append(createDbCallBack.getOtherInfo(colnamelist, prikeylist, partlist, tenantidCol));
            }
            allSqlBuf.append(";");
            retlist.add(allSqlBuf.toString());
        }
        return retlist;
    }

    public static Map<Pair<String, String>, List<MySqlColBean>> splitGroupByDbTb(List<MySqlColBean> cols, FieldFormart fieldFormart) {
        HashMap<Pair<String, String>, List<MySqlColBean>> colsBytable = new HashMap<Pair<String, String>, List<MySqlColBean>>();
        for (MySqlColBean colEle : cols) {
            Pair key = Pair.of((Object)colEle.getDb(), (Object)colEle.getTb());
            List<MySqlColBean> temp = colsBytable.containsKey(key) ? (List)colsBytable.get(key) : new ArrayList();
            colEle.setColumnName(colEle.getColumnNameStandard(fieldFormart));
            temp.add(colEle);
            colsBytable.put((Pair<String, String>)key, temp);
        }
        return colsBytable;
    }

    public static List<Triple<String, String, String>> getColsComment(Connection conn, String db, String tb, YesOrNo isRds) {
        try {
            Triple data;
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type,column_comment from  information_schema.columns  where  table_schema=? and table_name=? order by ORDINAL_POSITION");
            ArrayList<Triple<String, String, String>> retlist = new ArrayList<Triple<String, String, String>>();
            JdbcAssit.setPreParam(prepCols, null, true, db, tb);
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                data = Triple.of((Object)rs.getString(1), (Object)rs.getString(2), (Object)rs.getString(3));
                retlist.add((Triple<String, String, String>)data);
            }
            rs.close();
            if (CollectionUtils.isEmpty(retlist)) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u6570\u636e\u4e3a\u5e93\u5b58\u5728\u5e93\u540d\uff1a[" + db + "],\u8868\u540d\uff1a[" + tb + "]");
            }
            if (YesOrNo.yes == isRds && ArrayUtils.isEmpty((Object[])MySqlAssit.getPrimary(conn, db, tb))) {
                data = Triple.of((Object)"_rowkey_", (Object)"varchar", (Object)"varchar(255)");
                retlist.add((Triple<String, String, String>)data);
            }
            return retlist;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result setLocalInfile(Connection conn) {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute("set global local_infile=on");
            Result result = Result.getSuc();
            return result;
        }
        catch (Exception e) {
            Result result = Result.getError(e.getMessage());
            return result;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.error("close statement error", (Throwable)e);
            }
        }
    }
}

