/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.io;

import java.io.File;
import java.sql.Connection;
import java.util.List;

import javax.lang.model.element.Modifier;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeSpec.Builder;

import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

public abstract class JavaCodeAssit {
	/***
	 * 生成表对应的枚举类,由于工具类或组件不能固定好db,默认是needdb为false
	 */
	public static void proTableColEnum(Connection conn, String dbPattern, String tbPattern, String packageStr,
			String pathstr, boolean needdb) {
		try {
			List<String[]> tables = MySqlAssit.getAllTables(conn, dbPattern, tbPattern);
			for (String[] table : tables) {
				// 数据表静态字段
				FieldSpec tb = FieldSpec.builder(String.class, "_tb")
						.addModifiers(Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC).initializer("$S", table[1])
						.build();
				// TypeSpec
				Builder typeSpecBuild = TypeSpec
						.enumBuilder(StringUtil.toUpperCaseFirstOne(StringUtil.convertStr("cols_" + table[1])))
						.addModifiers(Modifier.PUBLIC).addField(String.class, "desc", Modifier.PRIVATE, Modifier.FINAL)
						.addField(String.class, "oriColName", Modifier.PRIVATE, Modifier.FINAL)

						.addField(tb)
						.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE)
								.addParameter(String.class, "oriColName")
								.addStatement("this.$N = $N", "oriColName", "oriColName")
								.addParameter(String.class, "desc").addStatement("this.$N = $N", "desc", "desc")
								.build())
						.addMethod(MethodSpec.methodBuilder("getDesc").addModifiers(Modifier.PUBLIC)
								.addStatement("return this.$N", "desc").returns(String.class).build())
						.addMethod(MethodSpec.methodBuilder("getOriColName").addModifiers(Modifier.PUBLIC)
								.addStatement("return this.$N", "oriColName").returns(String.class).build());
				if (needdb) {
					FieldSpec db = FieldSpec.builder(String.class, "_db")
							.addModifiers(Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC).initializer("$S", table[0])
							.build();
					typeSpecBuild.addField(db);
				}
				List<Triple<String, String, String>> colsNew = MySqlAssit.getColsComment(conn, table[0], table[1],
						YesOrNo.no);
				for (Triple<String, String, String> col : colsNew) {
					typeSpecBuild.addEnumConstant(StringUtil.convertStr(col.getLeft()),
							TypeSpec.anonymousClassBuilder("$S,$S", col.getLeft(), col.getRight()).build());
				}
				JavaFile javaFile = JavaFile.builder(packageStr, typeSpecBuild.build()).build();
				javaFile.writeTo(new File(PathType.getPath(pathstr, false)));
			}

		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.project_newjava, e);
		}
	}

	/****
	 * 产生po
	 * 
	 * @param conn
	 * @param dbPattern  要导出的库名（支持正则）
	 * @param tbPattern  要导出的表名（支持正则）
	 * @param packageStr 要导出的java文件所在包名
	 * @param pathstr    要导出文件的路径（支持PathType）
	 * @param skipFileds 需要跳过的字段名（驼峰,不是原名）
	 */
	public static void proTablePo(Connection conn, String dbPattern, String tbPattern, String packageStr,
			String pathstr, String... skipFileds) {
		try {
			List<String[]> tables = MySqlAssit.getAllTables(conn, dbPattern, tbPattern);
			for (String[] table : tables) {
				// TypeSpec
				Builder typeSpecBuild = TypeSpec
						.classBuilder(StringUtil.toUpperCaseFirstOne(StringUtil.convertStr(table[1])))
						.addModifiers(Modifier.PUBLIC).superclass(ClassName.get(packageStr + ".models", "BasePO"));
				typeSpecBuild.addAnnotation(Data.class);

				AnnotationSpec tbanno = AnnotationSpec.builder(ClassName.get("javax.persistence", "Table"))
						.addMember("name", "$S", table[1]).build();
				typeSpecBuild.addAnnotation(tbanno);

				List<Triple<String, String, String>> colsNew = MySqlAssit.getColsComment(conn, table[0], table[1],
						YesOrNo.no);
				for (Triple<String, String, String> col : colsNew) {
					String fieldName = StringUtil.convertStr(col.getLeft());
					if (ArrayUtils.isNotEmpty(skipFileds) && ArrayUtils.contains(skipFileds, fieldName)) {
						continue;
					}
					AnnotationSpec filedAnno = AnnotationSpec.builder(ClassName.get("javax.persistence", "Column"))
							.addMember("name", "$S", col.getLeft()).build();
					BinlogType mysqlType = BinlogType.getByName(col.getMiddle());
					FieldSpec field = FieldSpec.builder(mysqlType.getJavaType(), fieldName)
							.addModifiers(Modifier.PRIVATE).addAnnotation(filedAnno).build();
					typeSpecBuild.addField(field);
				}
				// addStaticImport在此加，
				JavaFile javaFile = JavaFile.builder(packageStr + ".models", typeSpecBuild.build()).build();
				javaFile.writeTo(new File(PathType.getPath(pathstr, false)));
			}

		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.project_newjava, e);
		}
	}

	/****
	 * 产生tams注解的po,这个po可以生成增删改查代码
	 * 
	 * @param conn
	 * @param dbPattern  要导出的库名（支持正则）
	 * @param tbPattern  要导出的表名（支持正则）
	 * @param packageStr 要导出的java文件所在包名
	 * @param pathstr    要导出文件的路径（支持PathType）
	 * @param skipFileds 需要跳过的字段名（驼峰,不是原名）,命中后就会会产生注解了
	 */
	public static void proTableTamsPo(Connection conn, String dbPattern, String tbPattern, String packageStr,
			String pathstr, String... skipFileds) {
		try {
			List<String[]> tables = MySqlAssit.getAllTables(conn, dbPattern, tbPattern);
			for (String[] table : tables) {
				// TypeSpec
				Builder typeSpecBuild = TypeSpec
						.classBuilder(StringUtil.toUpperCaseFirstOne(StringUtil.convertStr(table[1])))
						.addModifiers(Modifier.PUBLIC);
				AnnotationSpec tbanno = AnnotationSpec
						.builder(ClassName.get("net.wicp.tams.common.annotation", "TamsBean"))
						.addMember("title", "$S", table[1] + "管理").build();
				typeSpecBuild.addAnnotation(Data.class);
				typeSpecBuild.addAnnotation(tbanno);

				List<Triple<String, String, String>> colsNew = MySqlAssit.getColsComment(conn, table[0], table[1],
						YesOrNo.no);
				for (Triple<String, String, String> col : colsNew) {
					String fieldName = StringUtil.convertStr(col.getLeft());
					BinlogType mysqlType = BinlogType.getByName(col.getMiddle());
					com.squareup.javapoet.FieldSpec.Builder builder = FieldSpec
							.builder(mysqlType.getJavaType(), fieldName).addModifiers(Modifier.PRIVATE);
					if (ArrayUtils.isEmpty(skipFileds) || !ArrayUtils.contains(skipFileds, fieldName)) {
						AnnotationSpec filedAnno = AnnotationSpec
								.builder(ClassName.get("net.wicp.tams.common.annotation", "TamsCol"))
								.addMember("value", "$S", col.getRight()).addMember("save", "$L", 1)
								.addMember("query", "$L", 0).addMember("showWidth", "$L", "100").build();// 描述
						builder.addAnnotation(filedAnno);
					}
					FieldSpec field = builder.build();
					typeSpecBuild.addField(field);
				}
				// addStaticImport在此加，
				JavaFile javaFile = JavaFile.builder(packageStr, typeSpecBuild.build()).build();
				javaFile.writeTo(new File(PathType.getPath(pathstr, false)));
			}

		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.project_newjava, e);
		}
	}

}
