/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.exception;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ProjectExceptionRuntime extends RuntimeException implements IProjectException {
	private static final long serialVersionUID = 1L;
	private final IExcept except;

	public ProjectExceptionRuntime(IExcept except) {
		super(except.getDesc());
		this.except = except;
		log.error(getMessageAll());
	}

	public ProjectExceptionRuntime(IExcept except, Throwable cause) {
		super(except.getDesc(), cause);
		this.except = except;
		log.error(getMessageAll());
	}

	/****
	 * 当有自定义的错误原因时可用此构造函数
	 * 
	 * @param except 异常
	 * @param errMsg 错误信息
	 */
	public ProjectExceptionRuntime(IExcept except, String errMsg) {
		super(errMsg);
		this.except = except;
		log.error(getMessageAll());
	}

	public ProjectExceptionRuntime(IExcept except, String errMsg, Throwable cause) {
		super(errMsg, cause);
		this.except = except;
		log.error(getMessageAll());
	}

	/****
	 * 得到固定格式的异常信息
	 * 
	 * @param errBean 带参数Bean时要传入的实例
	 * @return 异常信息
	 */
	public String getMessageAll(Object errBean) {
		String errmsg = null;
		if (errBean == null) {
			errmsg = except.getErrMsg();
		} else {
			errmsg = except.getErrMsg(errBean);
		}
		StringBuffer sb = new StringBuffer();
		StackTraceElement[] es = this.getStackTrace();
		for (int i = 0; i < es.length; i++) {
			sb.append(es[i] + "\n");
		}
		return String.format("[code=%s],[value=%s],[message=%s],[sb=%s],[errormsg=%s],[原始异常产生原因:\n%s]",
				except.getErrorCode(), except.getErrorValue(), errmsg, super.getMessage(),
				getCause() == null ? "" : getCause().getMessage(), sb.toString());
	}

	/***
	 * 得到异常信息
	 */
	public String getMessageAll() {
		return getMessageAll(null);
	}

	public String getMessage(Object errBean) {
		String errmsg = null;
		if (errBean == null) {
			errmsg = except.getErrMsg();
		} else {
			errmsg = except.getErrMsg(errBean);
		}
		return String.format("错误代码: [code=%s],[value=%s],[message=%s],[原始异常产生原因:%s]", except.getErrorCode(),
				except.getErrorValue(), errmsg, super.getMessage());
	}

	public String getMessage() {
		return getMessage(null);
	}

	/***
	 * 得到异常对象
	 * 
	 * @return 异常对象
	 */
	public IExcept getExcept() {
		return this.except;
	}

}
