/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.ods;

import java.util.ArrayList;
import java.util.List;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 需要添加的字段对应的字段名，duckula可以支持这些字段
 * 
 * @author andy.zhou
 * 
 */
public enum AddColName implements IEnumCombobox {
	// 20220627支持watermark需要，类型改为TIMESTAMP
	commitTime("binlog时间", BinlogType.TIMESTAMP, "datetime", "_commit_time"), // 精确到秒,格式：yyyy-MM-dd HH:mm:ss
	// 20220627支持watermark需要，类型改为TIMESTAMP
	dumpTime("全量时间", BinlogType.TIMESTAMP, "datetime", "_dump_time"),

	lastOpttype("最后操作类型 insert/update/delete/dump", BinlogType.VARCHAR, "varchar", "_last_opttype"),

	isDelete("是否删除（1为删除0为未删除）", BinlogType.VARCHAR, "varchar", "_is_delete"),

	oriDb("源库名", BinlogType.VARCHAR, "varchar", "_ori_db"),

	oriTb("源表名", BinlogType.VARCHAR, "varchar", "_ori_tb"),

	oriInstid("源实例id", BinlogType.LONGLONG, "bigint", "_ori_inst");//LONG要改为LONGLONG，binlog类型的long为int. 源实例id，分库分表时有用。平台的common_installid

	private final String desc;

	private final BinlogType binlogType;

	private final String mysqlType;

	public String getMysqlType() {
		return mysqlType;
	}

	private final String defaultValue;// 默认列名

	public static AddColNameType addColType = AddColNameType.no;// 默认为不添加字段

	public BinlogType getBinlogType() {
		return binlogType;
	}

	// 插件目标的字段名，可以被覆盖
	private String colName;

	private AddColName(String desc, BinlogType binlogType, String mysqlType, String defaultValue) {
		this.desc = desc;
		this.binlogType = binlogType;
		this.defaultValue = defaultValue;
		this.mysqlType = mysqlType;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

//	public String getColName() {
//		return colName;
//	}
//
	public void setColName(String colName) {
		this.colName = colName;
	}

	// 有配置值
	public boolean isSetValue() {
		return StringUtil.isNotNull(this.colName);
	}

	// 得到真正的列名
	public String getColNameTrue(FieldFormart fieldFormart) {
		String colNameTemp;
		if (StringUtil.isNotNull(this.colName) && addColType != AddColNameType.selective_ori
				&& addColType != AddColNameType.all_ori) {
			colNameTemp = this.colName;
		} else {
			colNameTemp = this.defaultValue;
		}
		return fieldFormart.getColName(colNameTemp);
	}

	public static List<String> getAllColNameTrue(FieldFormart fieldFormart) {
		List<String> retlist = new ArrayList<String>();
		for (AddColName addColName : AddColName.values()) {
			retlist.add(addColName.getColNameTrue(fieldFormart));
		}
		return retlist;
	}

	public String getColNameTrue() {
		return getColNameTrue(FieldFormart.ori);
	}

	public static AddColName findByColName(FieldFormart fieldFormart, String colNameTrue) {
		AddColName retobj = null;
		if (StringUtil.isNull(colNameTrue)) {
			return retobj;
		}
		fieldFormart = fieldFormart == null ? FieldFormart.ori : fieldFormart;
		for (AddColName addColName : AddColName.values()) {
			if (colNameTrue.equals(addColName.getColNameTrue(fieldFormart))) {
				retobj = addColName;
				break;
			}
		}
		return retobj;
	}

	public static AddColName findByColName(String colNameTrue) {
		return findByColName(FieldFormart.ori, colNameTrue);
	}

}
