/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/****
 * 文件大小的单位
 * 
 * @author zhoujunhui
 *
 */
public enum SizeUnit implements IEnumCombobox {
	b("bit", new String[] { "b" },
			new String[] { "B,1/8", "KB,1/(8*1024)", "MB,1/(8*1024*1024)", "GB,1/(8*1024*1024*1024)",
					"TB,1/(8*1024*1024*1024*1024)" }),

	B("byte", new String[] { "B" },
			new String[] { "b,8", "KB,1/1024", "MB,1/(1024*1024)", "GB,1/(1024*1024*1024)",
					"TB,1/(1024*1024*1024*1024)" }),

	KB("Kilobyte", new String[] { "KB", "K", "kb", "k" },
			new String[] { "b,8*1024", "B,1024", "MB,1/1024", "GB,1/(1024*1024)", "TB,1/(1024*1024*1024)" }),

	MB("Megabyte", new String[] { "MB", "M", "mb", "m" },
			new String[] { "b,8*1024*1024", "B,1024*1024", "KB,1024", "GB,1/1024", "TB,1/(1024*1024)" }),

	GB("Gigabyte", new String[] { "GB", "G", "gb", "g" },
			new String[] { "b,8*1024*1024*1024", "B,1024*1024*1024", "KB,1024*1024", "MB,1024", "TB,1/1024" }),

	TB("Terabyte", new String[] { "TB", "T", "tb", "t" }, new String[] { "b,8*1024*1024*1024*1024",
			"B,1024*1024*1024*1024", "KB,1024*1024*1024", "MB,1024*1024", "GB,1024" });

	private final String desc;
	private final String[] convs;
	private final String[] fits;

	private SizeUnit(String desc, String[] fits, String[] convs) {
		this.desc = desc;
		this.convs = convs;
		this.fits = fits;
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc() {
		return this.name();
	}

	@Override
	public String getDesc_en() {
		return this.desc;
	}

	@Override
	public String getDesc_zh() {
		return this.name();
	}

	public Double conv(SizeUnit sizeUnit) {
		for (String conv : this.convs) {
			String[] eles = conv.split(",");
			if (eles[0].equals(sizeUnit.name())) {
				return (double) StringUtil.expr(eles[1]);
			}
		}
		return null;
	}

	public boolean includeUnit(String str) {
		String tempstr = StringUtil.trimSpace(str);
		return ArrayUtils.contains(this.fits, tempstr);
	}

	/***
	 * 翻译单位，如 “42.9 GB” 变为 42.9 和 G
	 * 
	 * @param str
	 * @return
	 */
	public static Pair<Double, SizeUnit> ConvertUnit(String str) {
		String strTrue = StringUtil.trimSpace(str);
		char[] numcharAry = new char[] { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.' };
		int endindex = 0;
		for (int i = 0; i < strTrue.length(); i++) {
			if (!ArrayUtils.contains(numcharAry, strTrue.charAt(i))) {
				endindex = i;
				break;
			}
		}
		SizeUnit sel = null;
		String unitstr = str.substring(endindex);
		for (SizeUnit temp : SizeUnit.values()) {
			if (temp.includeUnit(unitstr)) {
				sel = temp;
				break;
			}
		}
		return Pair.of(Double.parseDouble(str.substring(0, endindex)), sel);
	}

	public String filter(String str) {
		if (StringUtil.isNull(str)) {
			return str;
		}
		return str.replace(this.name(), "").replace(this.name().replace("B", ""), "");
	}
}
