/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 操作方式：同步、异步,默认为同步，没有找到则为同步
 * 
 * @author andy.zhou
 * 
 */
public enum OptWay implements IEnumCombobox {
	sync("同步"), async("异步");

	private final String desc;

	private OptWay(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static OptWay find(String name) {
		if (StringUtils.isEmpty(name)) {
			return sync;
		}
		for (OptWay ele : OptWay.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return sync;
	}
}
