/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 重要性等级
 * 
 * @author andy.zhou
 * 
 */
public enum GradeWeight implements IEnumCombobox {
	S("核心"), // super

	//A("优秀"),

	B("非核心"), // good

	//C("一般"), // cool

	//D("较差"), // dull 迟钝的

	//E("极差"),
	
	;

	private final String desc;

	private GradeWeight(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static GradeWeight find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (GradeWeight ele : GradeWeight.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
