/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.ArrayUtils;

/**
 * 
 * @author andy
 */
public enum StrPattern {

	char_normal("^[a-zA-Z0-9_\u4e00-\u9fa5]+$", "只含有汉字、数字、字母、下划线，下划线位置不限"),

	char_zh("[\u4e00-\u9fa5]", "只含有中文字符"),

	row_blank("\\n\\s*\\r", "含有空白行"), // 可以用来删除空白行

	email("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*", "需要传入eamil格式"),

	identity("\\d{15}|\\d{18}", "不是身份证"),

	date("^[0-9]{4}\\-[0-9]{1,2}\\-[0-9]{1,2}", "需要日期格式YYYY-M(M)-D(D)"),

	date2("^[0-9]{4}[0-9]{2}[0-9]{2}", "需要日期格式yyyyMMdd"), // 日期格式 yyyyMMdd

	date_time(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))( )(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))",
			"需要时间格式yyyy-MM-dd HH:mm:ss"), // 2006-09-09
	// 09:10:22

	date_time2(
			"^([0-9]{4})((0([1-9]{1}))|(1[0-2]))(([0-2]([0-9]{1}))|(3[0|1]))(([0-1]([0-9]{1}))|(2[0-4]))([0-5]([0-9]{1}))([0-5]([0-9]{1}))",
			"需要时间格式yyyyMMddHHmmss"), // 20060909091022

	// 示例是3精度，其实是N精度
	date_time_SSS(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))( )(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(.)([0-9]+)",
			"yyyy-MM-dd HH:mm:ss.SSS"),

	date_time_SSS2(
			"^([0-9]{4})((0([1-9]{1}))|(1[0-2]))(([0-2]([0-9]{1}))|(3[0|1]))(([0-1]([0-9]{1}))|(2[0-4]))([0-5]([0-9]{1}))([0-5]([0-9]{1}))([0-9]+)",
			"yyyyMMddHHmmssSSS"), // 20060909091022236

	date_time_t1(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))",
			"yyyy-MM-dd'T'HH:mm:ss"), // 2018-11-01T09:59:06
	
	// 示例是3精度，其实是N精度
	date_time_t12(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(.)([0-9]+)",
			"yyyy-MM-dd'T'HH:mm:ss.SSS"), //2022-10-27T15:49:10.624
	
	date_time_t13(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))",
			"yyyy-MM-dd'T'HH:mm"), // 2018-11-01T09:59

	date_time_t2(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(Z)",
			"yyyy-MM-dd'T'HH:mm:ss'Z'"), // 2018-11-01T10:08:03Z

	date_time_t3(
			"^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(CST)",
			"yyyy-MM-dd'T'HH:mm:ssz"), // 2018-11-01T10:09:36CST

	mobile_phone("^(13[0-9]|15[0|3|6|7|8|9]|18[6|8|9])\\d{8}$", "需要手机号码"),

	number_float("^(-?\\d+)(\\.\\d+)?$", "需要输入小数"), // 数字类型 浮点型

	number_float_positive("^\\d+(\\.\\d+)?$", "需要输入非负小数"), // 非负浮点数（正浮点数 + 0）

	number_integer("^-?\\d+$", "需要输入整数"), // 整数

	number_integer_positive("^\\d+$", "需要输入非负整数"), // 非负整数

	db_split("^\\w+_[0-9]{2}$", "分库的库名不合法"), // 分库模式

	tb_split("^\\w+_[0-9]{4}$", "分表的表名不合法"), // 分表模式

	split_pattern("\\s*[,]+\\s*", "需要逗号分隔"), // 逗号分隔模式

	db_name_pattern("(^_([a-zA-Z0-9]_?)*$)|(^[a-zA-Z](_?[a-zA-Z0-9])*_?$)", "首位可以是字母以及下划线,下划线后不能接下划线"), // 数据库名称规则
																										// 【首位可以是字母以及下划线,下划线后不能接下划线】

	catalog_tb_name_pattern("(^t_([a-zA-Z0-9]_?)*$)", "表名必须以t_开始,下划线后不能接下划线"), // catalog的表名规则【首位可以是字母以及下划线,下划线后不能接下划线】

	catalog_view_name_pattern("(^v_([a-zA-Z0-9]_?)*$)", "视图名必须以v_开始,下划线后不能接下划线"), // catalog的视图名规则

	rfc1123("(^([a-z0-9]-{0,1}){1,58}$)|(^[a-z](-?[a-z0-9]){1,58}-?$)", "只有中划线和数字小写字母组成，且不超过60个字符"), // 大写会报错。预留一下加前缀：t-
																										// c- d-等

	weburl("^(http|https):\\/\\/([\\w\\.\\:\\-\\_]+)\\/?\\S*$", "需要http或https地址"), // [\w\.\_] 相当于[0-9a-zA-Z\.\_]
																					// ，就是比\w多匹配 '.' 和 ‘_’ 两种字符

	httpurl("^(http):\\/\\/([\\w\\.\\:\\-\\_]+)\\/?\\S*$", "需要http地址"),

	httpsurl("^(https):\\/\\/([\\\\w\\.\\:\\-\\_]+)\\/?\\S*$", "需要https地址"),
	
	weburlsuffix("^\\.([\\w\\.\\:\\-\\_]+)$", "需要‘.’开始,去除第一段，如：ducckula.lcdev.cc的后缀为.lcdev.cc"),//weburl的域后缀，如：.lcdev.cc

	flinkversion("^(run.|data.){0,1}([0-9\\.]+)(-scala_([0-9\\\\.]+)){0,1}-java([1]{0,1}[0-9]{1})$", "flink镜像的版本"),

	cron("^\\s*($|#|\\w+\\s*=|(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?(?:,(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?)*)\\s+(\\?|\\*|(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?(?:,(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?)*)\\s+(\\?|\\*|(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?(?:,(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?)*|\\?|\\*|(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?(?:,(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?)*)\\s+(\\?|\\*|(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?(?:,(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?)*|\\?|\\*|(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?(?:,(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?)*)(|\\s)+(\\?|\\*|(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?(?:,(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?)*))$",
			"cron表达式规则需满足格式"),

	// 对应{ n } — exactly n rows (n > 0)
	// 或 { n, } — n or more rows (n ≥ 0)
	// 或{ n, m } — between n and m (inclusive) rows (0 ≤ n ≤ m, 0 < m)
	// 或{ , m } — between 0 and m (inclusive) rows (m > 0)
	pattern("^\\*|\\+|\\?|\\{(([1-9][0-9]*)|((0|[1-9][0-9]*),)|(,([1-9][0-9]*))|((0|[1-9][0-9]*),([1-9][0-9]*)))\\}|$",
			"匹配模式，如：* + ? {n} {n,} {,m} {n,m}"), // flink cep会用到
	
	//coltype("(?<datatype>[a-zA-Z0-9]+)(\\((?<precision>[0-9]+)\\,(?<scale>[0-9]+)\\) )?","列类型值，如：STRING,DECIMAL(10,2),TIMESTAMP_LTZ(3) *PROCTIME*"),
	coltype("(?<datatype>[a-zA-Z0-9]+)((\\((?<precision>[0-9]+)){1}(\\,(\\s)*(?<scale>[0-9]+){0,1}){1}\\))?","列类型值，如：STRING,DECIMAL(10,2)"),
	
	//jdbc:flink://localhost
	jdbcurl("jdbc:(?<type>[a-z]+)://(?<host>[a-zA-Z0-9-//.]+)(:(?<port>[0-9]+))?(/(?<database>[a-zA-Z0-9_]+))?(\\?(?<params>[?a-zA-Z0-9_=&]+))?",
			"jdbc地址"), //这个不需要加^和$

	no("[\\s\\S]*", "任意字符");// 或“([\d\D]*)”、“([\w\W]*)” 所有英英文：/[ -~]/ 所有非英文：/[^ -~]/

	private final String code;

	public String getCode() {
		return code;
	}

	private final String message;

	public String getMessage() {
		return message;
	}

	private StrPattern(String code, String message) {
		this.code = code;
		this.message = message;
	}

	/**
	 * 检查字符串格式是否正确
	 * 
	 * @param str 待检查的字符串
	 * @return boolean
	 */
	public boolean checkStrFormat(String str) {
		return checkStrFormat(code, str);
	}

	public Pattern compile() {
		Pattern pattern = Pattern.compile(this.code);
		return pattern;
	}

	/***
	 * 得到捕获组的
	 * 
	 * @param str
	 * @return
	 */
	public String[] group(String str,String[] groupNames) {
		return StrPattern.group(this.code, str,groupNames);
	}
	
	public String[] group(String str) {
		return StrPattern.group(this.code, str);
	}

	/***
	 * 得到捕获组的
	 * 
	 * @param str
	 * @return
	 */
	public static String[] group(String patternStr, String str,String... groupNames) {
		if (StringUtil.isNull(str)) {
			return new String[0];
		}
		Pattern pattern = Pattern.compile(patternStr);
		Matcher matcher = pattern.matcher(str);
		if (matcher.find()) {
			if(ArrayUtils.isNotEmpty(groupNames)) {
				String[] retary=new String[groupNames.length];
				for (int i = 0; i < retary.length; i++) {
					try {
						retary[i]=matcher.group(groupNames[i]);
					} catch (Exception e) {
						//可能没有此组，不抛异常。
					}
				}
				return retary;
			}else {
				String[] retary = new String[matcher.groupCount() + 1];
				for (int i = 0; i < retary.length; i++) {
					retary[i] = matcher.group(i);
				}
				return retary;
			}
			
			
			
		} else {
			return new String[0];
		}
	}

	public static boolean checkStrFormat(String patternStr, String str) {
		if (StringUtil.isNull(str)) {
			return false;
		}
		Pattern pattern = Pattern.compile(patternStr);
		Matcher matcher = pattern.matcher(str);

		boolean bool = matcher.matches();
		return bool;
	}
}
