/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;

import net.wicp.tams.common.annotation.TamsCol;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * 页面元素，BinlogType有关联天这个类型
 * 
 * @author andy.zhou
 * 
 */
public enum PageElement implements IEnumCombobox {
	ValidateBox("输入框", new PageElementOpt[] { PageElementOpt.missingmsg, PageElementOpt.strpattern }),

	ComboBox("下拉框",
			new PageElementOpt[] { PageElementOpt.enumclass, PageElementOpt.groups, PageElementOpt.url,
					PageElementOpt.textField, PageElementOpt.valueField, PageElementOpt.multiple, PageElementOpt.parent, PageElementOpt.parentLibs,
					PageElementOpt.changeHandle, PageElementOpt.mode, PageElementOpt.convertIgnore }),

	CheckBox("复选框", new PageElementOpt[] {}),

	Calendar("日历", new PageElementOpt[] { PageElementOpt.dateFmt }),

	NumberBox("号码框",
			new PageElementOpt[] { PageElementOpt.missingmsg, PageElementOpt.min, PageElementOpt.max,
					PageElementOpt.precision, PageElementOpt.groupsplit }), // double

	NumberIncrement("数字调整器", new PageElementOpt[] {}), // int

	//// ComboGrid不支持级联，不能设置PageElementOpt.parent
	/**
	 * 支持 combobox|combogrid到combobox 只能到combobox，不能到combogrid
	 */
	ComboGrid("表格下拉框",
			new PageElementOpt[] { PageElementOpt.columns, PageElementOpt.idField, PageElementOpt.panelWidth,
					PageElementOpt.panelHeight, PageElementOpt.textField, PageElementOpt.url,
					PageElementOpt.changeHandle, PageElementOpt.convertIgnore }),

	ComboTree("组合树",
			new PageElementOpt[] { PageElementOpt.columns, PageElementOpt.url, PageElementOpt.multiple,
					PageElementOpt.panelWidth }),

	Upload("文件上传组件（支持多文件）", new PageElementOpt[] { PageElementOpt.url }), // url为远程取文件的地址

	Yaml("yaml文件编辑", new PageElementOpt[] {}),

	Sql("sql文件编辑", new PageElementOpt[] { PageElementOpt.tableToColumnsUrl }),

	Propertygrid("属性编辑",
			new PageElementOpt[] { PageElementOpt.columns, PageElementOpt.showGroup, PageElementOpt.url,
					PageElementOpt.height, PageElementOpt.toolbar, PageElementOpt.parent,PageElementOpt.parentLibs }),

	PasswordBox("密码框", new PageElementOpt[] {});

	private final String desc;
	private final PageElementOpt[] pageEles;

	private PageElement(String desc, PageElementOpt[] pageEles) {
		this.desc = desc;
		this.pageEles = pageEles;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	/***
	 * 得到此类型的选项配置
	 * 
	 * @param optJsonStr
	 * @return
	 */
	private Map<PageElementOpt, String> findOpt(JSONObject optJson) {
		Map<PageElementOpt, String> retmap = new HashMap<PageElementOpt, String>();
		for (PageElementOpt pageElementOpt : this.pageEles) {// 需要的配置元素
			if (pageElementOpt == PageElementOpt.enumclass && "net.wicp.tams.common.constant.dic.intf.IEnumCombobox"
					.equals(optJson.getString(pageElementOpt.name()))) {// IEnumCombobox不算设置了值
				continue;
			}
			if (optJson.containsKey(pageElementOpt.name())
					|| StringUtil.isNotNull(optJson.getString(pageElementOpt.name()))) {// 包含相关数据
				retmap.put(pageElementOpt, optJson.getString(pageElementOpt.name()));
			} else {// 没有配置使用默认值
				retmap.put(pageElementOpt, pageElementOpt.getDefaultValue());
			}
		}
		return retmap;
	};

	@SuppressWarnings("unchecked")
	public Map<PageElementOpt, String> findOpt(TamsCol tamsCol) {
		String[] notObjectMethods = ReflectAssist.getNotObjectMethods(tamsCol.getClass());
		JSONObject retjson = new JSONObject();
		for (String notObjectMethod : notObjectMethods) {
			if (notObjectMethod.startsWith("opt_")) {
				String methodname = notObjectMethod.replace("opt_", "");
				String value = PageElementOpt.valueOf(methodname).getConvertValue()
						.getStr(ReflectAssist.invokeMothed(tamsCol, notObjectMethod));
				retjson.put(methodname, value);
			}
		}
		if (StringUtil.isNotNull(tamsCol.pageElementOpt())) {
			try {
				JSONObject eleoptJson = JSONObject.parseObject(tamsCol.pageElementOpt(), Feature.AllowSingleQuotes);
				retjson = JSONUtil.mergeJSON(retjson, eleoptJson);// 经过测试，以pageElementOpt配置为主，“opt_”相关元素如果与pageElementOpt有冲突的话会被冲掉
			} catch (Exception e) {
				throw new ProjectExceptionRuntime(ExceptAll.project_nosupport,
						"元素【" + tamsCol.value() + "】的opt不是json格式，请确认并修改", e);
			}
		}
		if("表的重要性".equals( tamsCol.value())) {
			System.out.println();
		}
		return findOpt(retjson);
	}

	/**
	 * 默认返回ValidateBox
	 * 
	 * @param name 要找的元素名
	 * @return
	 */
	public static PageElement find(String name) {
		if (StringUtils.isEmpty(name)) {
			return ValidateBox;
		}
		for (PageElement ele : PageElement.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return ValidateBox;
	}
}
