/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/****
 * 环境枚举
 * 
 * @author zhoujunhui
 *
 */
public enum Env implements IEnumCombobox {
	dev("开发环境"), 
	
	test("测试环境"), 
	
	pre("预发环境"), 
	
	prd("生产环境");

	private final String desc;

	private Env(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public static Env getByName(String env,Env defaultEnv) {
		if (StringUtil.isNull(env)) {// 默认是任意匹配
			return defaultEnv;
		}
		for (Env ele : Env.values()) {
			if (env.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return defaultEnv;
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}
	
	
	
	

}
