/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.dbtbconvert;

import org.apache.commons.lang3.tuple.Pair;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.constant.DrdsPattern;

public class DbTbConvertOds implements IDbTbConvert {

	private final int maxlength;

	private final String tbPre;

	// 要不要把db放进目标表名，默认： ods_db_tb ,如果它为false: ods_tb
	// 分库分表模式
	private final DrdsPattern drdsPattern;

	public DrdsPattern getDrdsPattern() {
		return drdsPattern;
	}

	public DbTbConvertOds() {
		this.maxlength = 64;
		this.tbPre = "ods";
		this.drdsPattern = DrdsPattern.no;
	}

	public DbTbConvertOds(int maxlength, DrdsPattern drdsPattern) {
		this.maxlength = maxlength;
		this.tbPre = "ods";
		this.drdsPattern = drdsPattern;
	}

	public DbTbConvertOds(String tbPre, DrdsPattern drdsPattern) {
		this.tbPre = tbPre;
		this.maxlength = 64;
		this.drdsPattern = drdsPattern;
	}

	/***
	 * 数仓用的的表
	 */
	@Override
	public Pair<String, String> getDbAndTb(String region, Pair<String, String> keyObj) {
		String dbstr = keyObj.getLeft().toLowerCase();
		dbstr = dbstr.replace("-", "_");
		String tbstr = keyObj.getRight().toLowerCase();
		tbstr = tbstr.replace("-", "_");

		String targetTbName = drdsPattern.getTargetTb(tbPre, Pair.of(dbstr, tbstr));

		// 要考虑1、不同库但同表 2、同库但前64个字符相同的表
		if (targetTbName.length() > this.maxlength) {
			int buildPort = StringUtil.buildPort(targetTbName);
			targetTbName = String.format("%s_%s", targetTbName.substring(0, this.maxlength - 6), buildPort);
		}
		return Pair.of(region, targetTbName);
	}

}
