/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.convertvalue.obj;

import org.apache.commons.lang3.tuple.Pair;

import net.wicp.tams.common.callback.ICreateDbCallBack;
import net.wicp.tams.common.callback.impl.dbtbconvert.DbTbConvertOds;
import net.wicp.tams.common.constant.DrdsPattern;

/***
 * 数据仓库命名规范，一般用于ods的迁移
 * 
 * @author Andy
 *
 */
public abstract class CreateDbCallBackOds implements ICreateDbCallBack {

	private final String region;

	private final DbTbConvertOds dbTbConvertOds;

	public CreateDbCallBackOds(String region) {
		this.region = region;
		this.dbTbConvertOds = new DbTbConvertOds(64,DrdsPattern.no);
	}

	@Override
	public String getDbAndTb(Pair<String, String> keyObj) {
		Pair<String, String> ret = dbTbConvertOds.getDbAndTb(this.region, keyObj);
		return String.format("%s.%s", ret.getLeft(),ret.getRight());
	}

}
