/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/****
 * 枚举类转换器，此枚举类必须继承net.wicp.tams.common.constant.dic.intf.IEnumCombobox
 * 
 * @author zhoujunhui
 *
 */
@SuppressWarnings("rawtypes")
@Slf4j
public class ConvertValueEnum implements IConvertValue<String> {
	private Object[] objs;
	private String lan;

	public ConvertValueEnum(Object[] obj, String lan) {
		this.objs = obj;
		this.lan = lan;
	}

	public ConvertValueEnum(Class classobj, String lan) {
		this.objs = classobj.getEnumConstants();
		this.lan = lan;
	}

	public ConvertValueEnum(Class classobj) {
		this(classobj, Conf.get("common.apiext.i18n"));
	}

	public ConvertValueEnum(String className, String lan) {
		try {
			Class classobj = Class.forName(className);
			this.objs = classobj.getEnumConstants();
			this.lan = lan;
		} catch (ClassNotFoundException e) {
		}
	}

	@Override
	public String getStr(String key) {
		if (StringUtil.isNull(key) || ArrayUtils.isEmpty(objs))
			return key;
		String[] keyeles = key.split(",", 0);// 多选的情况
		String[] values = keyeles.clone();// 默认为key值
		String filed = StringUtil.isNull(lan) ? "desc" : String.format("desc_%s", lan);
		for (Object object : objs) {
			IEnumCombobox tempobj = (IEnumCombobox) object;
			int indexOf = ArrayUtils.indexOf(keyeles, tempobj.getName());
			if (indexOf >= 0) {
				try {
					values[indexOf] = BeanUtils.getSimpleProperty(tempobj, filed);
				} catch (Exception e) {
					log.error("enum value[" + keyeles[indexOf] + "] convert error", e);
				}
			}
		}
		return CollectionUtil.arrayJoin(values, ",");
	}

}
