/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.thread.threadlocal.PerThreadValue;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Slf4j
public class ConvertValueEasyUIGrid implements IConvertValue<String> {
	private final String url;
	private final boolean cache;
	private final String idfield;
	private final String textfield;
	private JSONObject jsonObject;

	public ConvertValueEasyUIGrid(String url, String idfield, String textfield, boolean cache,
			Map<String, String> urlContext) {
		String urlTrue = url;
		if (MapUtils.isNotEmpty(urlContext)) {
			for (String contextKey : urlContext.keySet()) {
				urlTrue = urlTrue.replace(String.format("${%s}", contextKey), StringUtil.hasNull(urlContext.get(contextKey)));
			}
		}
		if (!StrPattern.weburl.checkStrFormat(urlTrue)) {// 是weburl
			String context = Conf.get("common.apiext.context");
			log.info("后端使用的context为：{}", context);
			urlTrue = StringUtil.isNull(context) ? urlTrue : IOUtil.mergeFolderAndFilePath(context, urlTrue);
		}
		if (cache) {
			try {
				JSONObject jsonObject = JSON.parseObject(ConvertValueEasyUIGrid.callUrlByTenant(urlTrue));
				this.jsonObject = jsonObject;
			} catch (Throwable e) {
				this.jsonObject = null;
			}

		} else {
			this.jsonObject = null;
		}

		this.url = urlTrue;
		this.cache = cache;
		this.idfield = idfield;
		this.textfield = textfield;
	}

	public ConvertValueEasyUIGrid(String url, Map<String, String> urlContext) {
		this(url, "id", "name", false, urlContext);
	}

	public ConvertValueEasyUIGrid(String url, String textfield, Map<String, String> urlContext) {
		this(url, "id", textfield, false, urlContext);
	}

	@Override
	public String getStr(String keyObj) {
		if (StringUtil.isNull(keyObj)) {
			return "";
		}
		try {
			JSONObject tempObjs = this.jsonObject;
			if (tempObjs == null) {
				tempObjs = JSON.parseObject(ConvertValueEasyUIGrid.callUrlByTenant(this.url));
				if (this.cache) {
					this.jsonObject = tempObjs;
				}
			}
			JSONArray array = tempObjs.getJSONArray("rows");
			for (int i = 0; i < array.size(); i++) {
				JSONObject jsonObject = array.getJSONObject(i);
				if (keyObj.equals(jsonObject.getString(idfield))) {
					return jsonObject.getString(textfield);
				}
			}
			return keyObj;
		} catch (Throwable e) {
			return keyObj;
		}

	}

	public static String callUrlByTenant(String url) {
		String[] head = null;
		Map<String, String> querymap = Conf.getPre("common.jdbc.sqlIntercept.colnameQuery", true);
		if (MapUtils.isNotEmpty(querymap) && querymap.containsKey("tenant_id")) {
			PerThreadValue<String> value = PerthreadManager.getInstance().createValue(querymap.get("tenant_id"),
					String.class);
			if (value.exists() && StringUtil.isNotNull(value.get())) {
				// head头错误：tams:sqlIntercept:tenant_id改为："tenant_id"
				head = new String[] { "tenant_id", value.get() };
			}
		}
		String result = IOUtil.doPostOrGet(url, "", head);
		return result;
	}

}
