/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.DateFormatCase;

/****
 * 把时间转为String
 * 
 * @author zhoujunhui
 *
 */
public class ConvertValueDate implements IConvertValue<String> {
	private DateFormatCase formate;

	public ConvertValueDate(DateFormatCase formate) {
		this.formate = formate;
	}

	/***
	 * 默认的格式是 “yyyy-MM-DD”
	 */
	public ConvertValueDate() {
		this.formate = DateFormatCase.YYYY_MM_DD;
	}

	@Override
	public String getStr(String keyObj) {
		SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", java.util.Locale.US);
		try {
			Date date = sdf.parse(keyObj);
			return this.formate.getInstanc().format(date);
		} catch (ParseException e) {
			return keyObj;
		}
	}

}
