/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import net.wicp.tams.common.apiext.jdbc.MySqlColBean;

/***
 * 生成建表语名需要实现的接口
 * 
 * @author Administrator
 *
 */
public interface ICreateDbCallBack {
	/***
	 * 生成创表的“库名.表名”
	 * 
	 * @param keyObj
	 * @return
	 */
	public String getDbAndTb(Pair<String, String> keyObj);

	/**
	 * 得到建表的附加属性。
	 * 
	 * @param cols
	 * @param keys
	 * @return
	 */
	public String getOtherInfo(List<String> cols, List<String> keys, List<String> parts, MySqlColBean tenantidCol);
	

	/**
	 * 跟据规则得到数据类型
	 * 
	 * @param mySqlColBean 源字段信息
	 * @param bigColNames  大字段列
	 * @return
	 */
	public default String getColumnType(MySqlColBean mySqlColBean, List<MySqlColBean> bigColNames) {
		return mySqlColBean.getColumnType();
	}
}
