/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.beans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.google.common.io.ByteStreams;

import lombok.Data;
import net.wicp.tams.common.callback.IProcess;

@Data
public class StreamCopyBean implements IProcess {
	// 目标
	private InputStream thatIn;
	private OutputStream thatOut;
	private OutputStream thatError;
	// 源（本终端）
	private InputStream thisIn;
	private OutputStream thisOut;
	private InputStream thisError;

	public static StreamCopyBean procToSystem(Process proc) {
		StreamCopyBean retbean = new StreamCopyBean();
		retbean.setThisIn(proc.getInputStream());
		retbean.setThisOut(proc.getOutputStream());
		retbean.setThisError(proc.getErrorStream());

		retbean.setThatIn(System.in);
		retbean.setThatOut(System.out);
		retbean.setThatError(System.err);
		return retbean;
	}

	public void copyOutputStream() {
		try {
			ByteStreams.copy(this.thatIn, this.thisOut);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	public void copyInputStream() {
		try {
			ByteStreams.copy(this.thisIn, this.thatOut);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	public void copyErrorStream() {
		try {
			ByteStreams.copy(this.thisError, this.thatError);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void doInputStream(InputStream inputStream) {
		copyInputStream();
	}

	@Override
	public void doOutputStream(OutputStream outputStream) {
		copyOutputStream();
	}

	@Override
	public void doErrorStream(InputStream errorStream) {
		copyErrorStream();
	}

}
