/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.yaml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.reader.UnicodeReader;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.PathType;

public abstract class YamlAssist {
	/****
	 * 检查yaml是否合法
	 * 
	 * @param fileInputStream 文件的流
	 * @return 检查的结果
	 */
	@SuppressWarnings({ "unused" })
	public static Result isOk(FileInputStream fileInputStream) {
		Yaml yaml = new Yaml(new StrictMapAppenderConstructor());
		Result retobj = null;
		try {
			Reader reader = new UnicodeReader(fileInputStream);
			for (Object obj : yaml.loadAll(reader)) {
			}
			retobj = Result.getSuc();
		} catch (Exception e) {
			retobj = Result.getError(e.getMessage());
		}
		return retobj;
	}

	public static Result isOk(String fileName) {
		FileInputStream inputstream;
		try {
			inputstream = new FileInputStream(fileName);
		} catch (FileNotFoundException e) {
			return Result.getError("文件不存在");
		}
		return isOk(inputstream);
	}

	@SuppressWarnings("rawtypes")
	public static JSONObject readYaml(FileInputStream fileInputStream) {
		Yaml yaml = new Yaml();
		Map map = (Map) yaml.load(fileInputStream);
		JSONObject json = JSONObject.parseObject(JSONUtil.getJsonForMap(map));
		return json;
	}

	public static JSONObject readYamlByPathType(String pathTypepath) {
		return readYaml(PathType.getPath(pathTypepath));
	}

	public static JSONObject readYamlStr(String yamlstr) {
		Yaml yaml = new Yaml();
		Map map = (Map) yaml.load(yamlstr);
		JSONObject json = JSONObject.parseObject(JSONUtil.getJsonForMap(map));
		return json;
	}

	public static JSONObject readYaml(String filePath) {
		FileInputStream inputstream = null;
		try {
			inputstream = new FileInputStream(filePath);
			JSONObject retjson = readYaml(inputstream);
			return retjson;
		} catch (FileNotFoundException e) {
			throw new IllegalArgumentException("file not exit");
		} finally {
			try {
				inputstream.close();
			} catch (Exception e) {
			}
		}
	}

	/**
	 * yml文件流转成单层map 转Properties 改变了顺序
	 * 
	 * @param yamlContent
	 * @return
	 */
	public static Map<String, Object> yamlToFlattenedMap(String yamlContent) {
		Yaml yaml = createYaml();
		Map<String, Object> map = new HashMap<>();
		for (Object object : yaml.loadAll(yamlContent)) {
			if (object != null) {
				map = CollectionUtil.asMap(object);
				map = CollectionUtil.getFlattenedMap(map);
			}
		}
		return map;
	}

	/**
	 * yml文件流转成多次嵌套map
	 * 
	 * @param yamlContent
	 * @return
	 */
	public static Map<String, Object> yamlToMultilayerMap(String yamlContent) {
		Yaml yaml = createYaml();
		Map<String, Object> result = new LinkedHashMap<>();
		for (Object object : yaml.loadAll(yamlContent)) {
			if (object != null) {
				result.putAll(CollectionUtil.asMap(object));
			}
		}
		return result;
	}

	/**
	 * 多次嵌套map转成yml
	 * 
	 * @param map
	 * @return
	 */
	public static String multilayerMapToYaml(Map<String, Object> map) {
		Yaml yaml = createYaml();
		return yaml.dumpAsMap(map);
	}

	/**
	 * 单层map转成yml
	 * 
	 * @param map
	 * @return
	 */
	public static String flattenedMapToYaml(Map<String, Object> map) {
		Yaml yaml = createYaml();
		return yaml.dumpAsMap(CollectionUtil.flattenedMapToMultilayerMap(map));
	}

	private static Yaml createYaml() {
		return new Yaml(new Constructor());
	}

}
