/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.json;

import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINode;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINodeConf;

@Data
@Slf4j
public class SimpleTreeNode {
	private String id;
	private String text;
	private String parent;

	public static List<EasyUINode> createTree(List<SimpleTreeNode> nodes) {
		final EasyUINodeConf conf = new EasyUINodeConf("id", "text", "parent");
		List<EasyUINode> roots;
		try {
			roots = EasyUiAssist.getTreeRoot(nodes, conf);
			return roots;
		} catch (Exception e) {
			log.error("创建简单树错误：",e);
			return null;
		}

		/*
		 * try { roots = EasyUiAssist.getTreeRoot(nodes, conf); String treestr =
		 * EasyUiAssist.getTreeFromList(roots); return treestr.replace("\"",
		 * "'").replace("\n", "").replace(" ", ""); } catch (Exception e) {
		 * log.error("转为task树错误", e); return "[]"; }
		 */
	}

	public SimpleTreeNode(String id, String text, String parent) {
		super();
		this.id = id;
		this.text = text;
		this.parent = parent;
	}

	public SimpleTreeNode(String text, String parent) {
		this(text, text, parent);
	}
}
