/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.json;

import java.util.Map;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;

public interface IQueryAssetInfo {
	@SuppressWarnings("rawtypes")
	public Map<String, IConvertValue> queryAlisConvert();

	/***
	 * 由输入的列名得到原始的列名
	 * 
	 * @param inputColName 输入的列名
	 * @return
	 */
	public default String getOriColName(String inputColName) {
		if (StringUtil.isNull(inputColName) && !inputColName.endsWith("1")) {
			return inputColName;
		}
		return inputColName.substring(0, inputColName.length() - 1);
	}

	/**
	 * 由原始列名得到别名用的列名
	 * 
	 * @param oriColName 原始列名
	 * @return
	 */
	public default String getKeyColName(String oriColName) {
		return oriColName + "1";
	}
}
