/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.json;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.annotation.TamsBean;
import net.wicp.tams.common.annotation.TamsCol;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINode;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINodeConf;
import net.wicp.tams.common.beans.QueryAssetInfo;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueDate;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEasyUICombobox;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEasyUIGrid;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEnum;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.PageElement;
import net.wicp.tams.common.constant.PageElementOpt;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * easyui辅助类
 * 
 * @author andy.zhou
 *
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public abstract class EasyUiAssist {

	// {"total":28,"rows":[
	// {"productid":"FI-SW-01","productname":"Koi","unitcost":10.00,"status":"P","listprice":36.50,"attr1":"Large","itemid":"EST-1"},
	// {"productid":"K9-DL-01","productname":"Dalmation","unitcost":12.00,"status":"P","listprice":18.50,"attr1":"Spotted
	// Adult Female","itemid":"EST-10"},
	// {"productid":"RP-SN-01","productname":"Rattlesnake","unitcost":12.00,"status":"P","listprice":38.50,"attr1":"Venomless","itemid":"EST-11"},
	// {"productid":"RP-SN-01","productname":"Rattlesnake","unitcost":12.00,"status":"P","listprice":26.50,"attr1":"Rattleless","itemid":"EST-12"},
	// ]}
	/***
	 * 返回格式： {"total":12,"rows":[{"itemCode":"checkNoPass","itemName":"质检不通过"},{
	 * "itemCode":"checkPass","itemName":"质检通过"}]}
	 * 
	 * @param fromList  要取的源数据
	 * @param titles    要取的标题，支持别名，如：new
	 *                  String[]{""itemCode,itemCode","itemName_zh,itemName""}
	 *                  itemName_zh为是取值的列名,itemName要显示的列名
	 * @param jsonCols  json处理
	 * @param recordNum 记录总数
	 * @return Grid的String形式
	 */
	public static String getJsonForGrid(List<?> fromList, String[] titles, List<String> jsonCols,
			List<String> base64Cols, long recordNum) {
		StringBuffer buff = new StringBuffer("{\"total\":" + recordNum + ",\"rows\":");
		buff.append(JSONUtil.getJsonForListJsonCol(fromList, jsonCols, base64Cols, titles));
		buff.append("}");
		return buff.toString();
	}

	public static <T extends IEnumCombobox> String getJsonForGridByEnum(Map<T, String> datas) {
		StringBuffer buff = new StringBuffer("{\"total\":" + datas.size() + ",\"rows\":");
		JSONArray retary = new JSONArray();
		for (IEnumCombobox key : datas.keySet()) {
			JSONObject obj = new JSONObject();
			obj.put("name", key.getName());
			obj.put("nameUse", key.getNameUse());
			obj.put("desc", key.getDesc());
			// obj.put("group", key.getGroupSub());// 分组，要它起作用，需要设置showGroup为true
			obj.put("value", datas.get(key));
			obj.put("editor", "text");// 暂时只用text,后面扩展
			retary.add(obj);
		}
		String jsonString = JSONArray.toJSONString(retary);// SerializerFeature.UseSingleQuotes
		buff.append(jsonString);
		buff.append("}");
		return buff.toString();
	}

	public static String getJsonForGrid(List<?> fromList, String[] titles, long recordNum) {
		return getJsonForGrid(fromList, titles, Collections.EMPTY_LIST, Collections.EMPTY_LIST, recordNum);
	}

	/***
	 * 某些字段需要json数据，而不是string，如Propertygrid的edit
	 * 
	 * @param gridJsonstr
	 * @param jsonCols
	 * @return
	 */
	public static String converJson(String gridJsonstr, String... jsonCols) {
		JSONObject jsonObject = JSONObject.parseObject(gridJsonstr);
		JSONArray rows = jsonObject.getJSONArray("rows");
		for (String jsonCol : jsonCols) {
			for (Object object : rows) {
				JSONObject tempobj = (JSONObject) object;
				String string = tempobj.getString(jsonCol);
				JSONObject parseObject = JSONObject.parseObject(string);
				tempobj.put(jsonCol, parseObject);
			}
		}
		String jsonString = JSONObject.toJSONString(jsonObject);
		return jsonString;
	}

	/***
	 * 可以自定义转换格式
	 * 
	 * @param fromList  要取的源数据
	 * @param titles    要取的标题，支持别名，如：new
	 *                  String[]{""itemCode,itemCode","itemName_zh,itemName""}
	 *                  itemName_zh为是取值的列名,itemName要显示的列名
	 * @param converts  转换器数组
	 * @param jsonCols  json处理
	 * @param recordNum 记录总数
	 * @return Grid的String形式
	 */

	public static String getJsonForGrid(List<?> fromList, String[] titles, IConvertValue[] converts,
			List<String> jsonCols, List<String> base64Cols, long recordNum) {
		StringBuffer buff = new StringBuffer("{\"total\":" + recordNum + ",\"rows\":");
		buff.append(JSONUtil.getJsonForList(fromList, converts, jsonCols, base64Cols, titles));
		buff.append("}");
		return buff.toString();
	}

	public static String getJsonForGrid(List<?> fromList, String[] titles, IConvertValue[] converts, long recordNum) {
		return getJsonForGrid(fromList, titles, converts, Collections.EMPTY_LIST, Collections.EMPTY_LIST, recordNum);
	}

	/***
	 * 得到grid用的json
	 * 
	 * @param fromList    源对象
	 * @param titles      要生成的字段名
	 * @param convertsMap 转换函数
	 * @param jsonCols    json处理
	 * @param recordNum   数据数量
	 * @return Grid的String形式
	 */
	public static String getJsonForGrid(List<?> fromList, String[] titles,
			Map<String, IConvertValue<String>> convertsMap, List<String> jsonCols, List<String> base64Cols,
			long recordNum) {
		StringBuffer buff = new StringBuffer("{\"total\":" + recordNum + ",\"rows\":");
		buff.append(JSONUtil.getJsonForList(fromList, convertsMap, jsonCols, base64Cols, titles));
		buff.append("}");
		return buff.toString();
	}

	public static String getJsonForGrid(List<?> fromList, String[] titles,
			Map<String, IConvertValue<String>> convertsMap, long recordNum) {
		return getJsonForGrid(fromList, titles, convertsMap, Collections.EMPTY_LIST, Collections.EMPTY_LIST, recordNum);
	}

	/****
	 * 把数据以json格式返回，不需要指定已有字段。
	 * 
	 * @param fromList    源数据
	 * @param aliasTitles 别名列表
	 * @param convertsMap 别名转换字段
	 * @param recordNum   记录数
	 * @return Grid的String形式
	 */
	public static String getJsonForGridAlias(List<?> fromList, String[] aliasTitles,
			Map<String, IConvertValue<String>> convertsMap, long recordNum) {
		if (CollectionUtils.isEmpty(fromList)) {
			return getJsonForGrid(fromList, new String[] {}, convertsMap, 0L);
		}
		Object object = fromList.get(0);
		String[] titles = null;
		if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
			Map temp = (Map) object;
			titles = new String[temp.size()];
			int i = 0;
			for (Object keyObj : temp.keySet()) {
				titles[i++] = String.valueOf(keyObj);
			}
		} else {
			List<String> fields = ReflectAssist.findGetField(object.getClass());
			titles = fields.toArray(new String[fields.size()]);
		}
		if (aliasTitles != null && aliasTitles.length > 0) {
			titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles, false);
		}
		return getJsonForGrid(fromList, titles, convertsMap, recordNum);
	}

	/***
	 * 原始数据字段+别名字段集合做为 title
	 * 
	 * @param fromList      原始数据
	 * @param aliasTitles   别名集合
	 * @param convertsMap   转换器
	 * @param recordNum     记录个数
	 * @param excludeFields 需要排除的字段
	 * @return
	 */
	public static String getJsonForGridAlias2(List<?> fromList, String[] aliasTitles,
			Map<String, IConvertValue> convertsMap, long recordNum, List<String> jsonCols, List<String> base64Cols,
			String... excludeFields) {
		if (CollectionUtils.isEmpty(fromList)) {
			return getJsonForGrid(fromList, new String[] {}, new IConvertValue[] {}, 0L);
		}
		Object object = fromList.get(0);
		String[] titles = null;
		if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
			Map temp = (Map) object;
			titles = new String[temp.size()];
			int i = 0;
			for (Object keyObj : temp.keySet()) {
				titles[i++] = String.valueOf(keyObj);
			}
		} else {
			List<String> fields = ReflectAssist.findGetField(object.getClass());
			titles = fields.toArray(new String[fields.size()]);
		}
		if (aliasTitles != null && aliasTitles.length > 0) {
			titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles, false);
		}
		// 排除某些字段，如 text大字符串，一节省查询时间，二防止导致json格式问题查不出来
		titles = ArrayUtils.removeElements(titles, excludeFields);
		IConvertValue[] converAry = new IConvertValue[titles.length];
		for (int i = 0; i < titles.length; i++) {
			String[] title = titles[i].split(",");
			String value = title.length > 1 ? title[1] : title[0];
			if (convertsMap.get(value) == null) {
				converAry[i] = null;
			} else {
				converAry[i] = convertsMap.get(value);
			}
		}
		return getJsonForGrid(fromList, titles, converAry, jsonCols, base64Cols, recordNum);
	}

	public static String getJsonForGridAlias2(List<?> fromList, String[] aliasTitles,
			Map<String, IConvertValue> convertsMap, long recordNum, String... excludeFields) {
		return getJsonForGridAlias2(fromList, aliasTitles, convertsMap, recordNum, Collections.EMPTY_LIST,
				Collections.EMPTY_LIST, excludeFields);
	}

	/***
	 * 通过拿注解的方式得到grid的json数据
	 * 
	 * @param <T>
	 * @param classz        要转换的类
	 * @param fromList      要转换的数据
	 * @param recordNum     数据的总条数
	 * @param excludeFields 需要排除的字段
	 * @param paramContext  支持动态参数。
	 * @return
	 */
	public static <T> String getJsonForGridAlias2(Class<T> classz, IQueryAssetInfo userQueryAlisConvert,
			List<T> fromList, long recordNum, List<String> jsonCols, List<String> base64Cols,
			Map<String, String> paramContext, String... excludeFields) {
		QueryAssetInfo queryAssetInfo = EasyUiAssist.getQueryAssetInfo(classz, userQueryAlisConvert, paramContext);
		return EasyUiAssist.getJsonForGridAlias2(fromList, queryAssetInfo.getConvertTitle(),
				queryAssetInfo.getConvertMap(), recordNum, jsonCols, base64Cols, excludeFields);
	}

	/***
	 * 得到Query组件用的查询用的辅助信息 L:标题，用于显示查询结果的列定义。显示的列标题 M：convert转换器用的标题 R:
	 * convert转换器用的转换器
	 * 
	 * @return
	 */
	public static <T> QueryAssetInfo getQueryAssetInfo(Class<T> classz, IQueryAssetInfo queryAssetInfo,
			Map<String, String> paramContext) {
		QueryAssetInfo retobj = new QueryAssetInfo();
		List<String> aliasTitleList = new ArrayList<String>();
		Map<String, IConvertValue> convertsMap = new HashMap<String, IConvertValue>();
		StringBuffer colTitlebuf = new StringBuffer();
		// 配置默认的IQueryAssetInfo
		queryAssetInfo = queryAssetInfo == null ? (new IQueryAssetInfo() {
			@Override
			public Map<String, IConvertValue> queryAlisConvert() {
				return null;
			}
		}) : queryAssetInfo;
		Map<String, IConvertValue> userQueryAlisConvert = queryAssetInfo.queryAlisConvert();
		if (MapUtils.isNotEmpty(userQueryAlisConvert)) {
			convertsMap.putAll(userQueryAlisConvert);
		}

/////////////////////////////////////////////////////////////////////////////////////////所有字段处理///////////////////////////////////////////
		List<Field> tamsFields = ReflectAssist.findFields(classz, TamsCol.class, null);
		// 查到排除的列名
		List<Field> excludeField = (List<Field>) CollectionUtils.select(tamsFields, new Predicate() {

			@Override
			public boolean evaluate(Object object) {
				TamsCol tamsCol = ((Field) object).getDeclaredAnnotation(TamsCol.class);
				return tamsCol.excludeField();
			}
		});
		List<String> excludeFieldNames = new ArrayList<String>();
		if (CollectionUtils.isNotEmpty(excludeField)) {
			for (Field field : excludeField) {
				excludeFieldNames.add(field.getName());
			}
		}
		retobj.setExcludeFields(excludeFieldNames.toArray(new String[excludeFieldNames.size()]));
		// 过滤排除的字段
		CollectionUtils.filter(tamsFields, new Predicate() {
			@Override
			public boolean evaluate(Object object) {
				Field temp = (Field) object;
				return !excludeFieldNames.contains(temp.getName());
			}
		});

		Collections.sort(tamsFields, TamsCol.comparator);
		List<String> aliasNames = new ArrayList<String>();
		List<String> jsonCols = new ArrayList<String>();
		List<String> base64Cols = new ArrayList<String>();
		Map<String, Object> fieldDefaultValueMap = new HashMap<String, Object>();
		for (int i = 0; i < tamsFields.size(); i++) {
			TamsCol tamsCol = tamsFields.get(i).getAnnotation(TamsCol.class);
			if (tamsCol.jsonFormat()) {// 即使不显示也要处理，因为修改要使用这些数据
				jsonCols.add(tamsFields.get(i).getName());
			}
			if (tamsCol.base64()) {
				base64Cols.add(tamsFields.get(i).getName());
			}
			if (StringUtil.isNotNull(tamsCol.defaultvalue())) {
				JSONObject ele = new JSONObject();
				ele.put("value", tamsCol.defaultvalue());
				ele.put("ele", tamsCol.pageElement().name());
				fieldDefaultValueMap.put(tamsFields.get(i).getName(), ele);
			}
			if (tamsCol.showWidth() <= 0) {// 需要显示并查询才生成其它字段
				continue;
			}
			String alisColName = queryAssetInfo.getKeyColName(tamsFields.get(i).getName());
			if (MapUtils.isNotEmpty(userQueryAlisConvert) && userQueryAlisConvert.containsKey(alisColName)) {// 用户已指定转换器
				aliasAdd(aliasTitleList, aliasNames, tamsFields.get(i).getName(), alisColName);
				convertsMap.put(alisColName, userQueryAlisConvert.get(alisColName));
			} else {
				PageElement pageElement = tamsCol.pageElement();
				// String pageElementOpt = tamsCol.pageElementOpt();
				// colNames[i] = tamsCol.value();
				Map<PageElementOpt, String> optmap = pageElement.findOpt(tamsCol);
				switch (pageElement) {
				case ComboBox:
					aliasAdd(aliasTitleList, aliasNames, tamsFields.get(i).getName(), alisColName);
					if (optmap.containsKey(PageElementOpt.enumclass)
							&& !"net.wicp.tams.common.constant.dic.intf.IEnumCombobox"
									.equals(optmap.get(PageElementOpt.enumclass))) {

						convertsMap.put(alisColName, new ConvertValueEnum(optmap.get(PageElementOpt.enumclass),
								Conf.get("common.apiext.i18n")));
					} else {
						if (optmap.containsKey(PageElementOpt.convertIgnore)
								&& YesOrNo.no.name().equalsIgnoreCase(optmap.get(PageElementOpt.convertIgnore))) {// combobx也可以不需要转换器，直接显示value
							String url = StringUtil.packageUrlParams(optmap.get(PageElementOpt.url), "text",
									optmap.get(PageElementOpt.textField), "value",
									optmap.get(PageElementOpt.valueField));
							ConvertValueEasyUICombobox convertValueEasyUICombobox = new ConvertValueEasyUICombobox(url,
									optmap.get(PageElementOpt.textField), optmap.get(PageElementOpt.valueField), true,
									paramContext);
							convertsMap.put(alisColName, convertValueEasyUICombobox);
						}
					}
					break;
				case Calendar:
					aliasAdd(aliasTitleList, aliasNames, tamsFields.get(i).getName(), alisColName);
					DateFormatCase find = DateFormatCase.find(optmap.get(PageElementOpt.dateFmt));
					convertsMap.put(alisColName, new ConvertValueDate(find));
					break;
				case ComboGrid:
					aliasAdd(aliasTitleList, aliasNames, tamsFields.get(i).getName(), alisColName);
					if (optmap.containsKey(PageElementOpt.convertIgnore)
							&& YesOrNo.no.name().equalsIgnoreCase(optmap.get(PageElementOpt.convertIgnore))) {// ComboGrid也可以不需要转换器，直接显示value
						ConvertValueEasyUIGrid convertValueEasyUIGrid = new ConvertValueEasyUIGrid(
								optmap.get(PageElementOpt.url), optmap.get(PageElementOpt.idField),
								optmap.get(PageElementOpt.textField), false, paramContext);
						convertsMap.put(alisColName, convertValueEasyUIGrid);
					}
					break;
				default:
					break;
				}

			}
			// {field:'name',width:200,title:'kafka消费者'}
			colTitlebuf.append(String.format(",{field:'%s',width:%s,title:'%s'}",
					convertsMap.containsKey(alisColName) ? alisColName : tamsFields.get(i).getName(),
					tamsCol.showWidth(), tamsCol.value()));
			// 前面默认的convert修理完后，处理自定义的convert

			if (ArrayUtils.isNotEmpty(tamsCol.convert())) {
				for (String convertstr : tamsCol.convert()) {
					// eg:"abc,100,helm状态"
					String[] convertEles = convertstr.split(",");
					if (convertEles.length != 3) {
						throw new ProjectExceptionRuntime(ExceptAll.param_error,
								"TamsCol的convert配置需要3列，分别对应：转换后字段:显示宽度（默认100）:grid显示title,原始字段为该字段名");
					}
					aliasAdd(aliasTitleList, aliasNames, tamsFields.get(i).getName(), convertEles[0]);
					colTitlebuf.append(String.format(",{field:'%s',width:%s,title:'%s'}", convertEles[0],
							convertEles[1], convertEles[2]));
				}
			}

		}
/////////////////////////////////////////////////////////////////////////////////////////非字段或字段第2转换器处理///////////////////////////////////////////
		TamsBean tamsbean = classz.getAnnotation(TamsBean.class);
		if (tamsbean != null && ArrayUtils.isNotEmpty(tamsbean.convert())) {
			for (String convert : tamsbean.convert()) {
				// eg:",helmStatus,100,helm状态"
				String[] fileAry = convert.split(",");
				if (fileAry.length != 4) {
					throw new ProjectExceptionRuntime(ExceptAll.param_error,
							"TamsBean的convert配置需要4列，分别对应：原字段:转换后字段:显示宽度（默认100）:grid显示title");
				}
				aliasAdd(aliasTitleList, aliasNames, fileAry[0], fileAry[1]);
				colTitlebuf
						.append(String.format(",{field:'%s',width:%s,title:'%s'}", fileAry[1], fileAry[2], fileAry[3]));
			}
		} else {// 如果没有配置tamsbean，也没有配置TamsCol时需要把
			if (MapUtils.isNotEmpty(userQueryAlisConvert)) {
				for (String colsalias : userQueryAlisConvert.keySet()) {
					boolean isConf = false;// 是否已有配置
					for (String titleAll : aliasTitleList) {
						if (titleAll.contains("," + colsalias)) {// 已经配置好了。
							isConf = true;
							break;
						}
					}
					if (!isConf) {
						aliasAdd(aliasTitleList, aliasNames, queryAssetInfo.getOriColName(colsalias), colsalias);
					}
				}
			}
		}
		String colStr = colTitlebuf.length() > 0 ? colTitlebuf.substring(1) : "";
		retobj.setGridTitleCols(String.format("[[%s]]", colStr));
		retobj.setConvertTitle(aliasTitleList.toArray(new String[aliasTitleList.size()]));
		retobj.setConvertMap(convertsMap);
		retobj.setJsonCols(jsonCols);
		retobj.setBase64Cols(base64Cols);
		retobj.setFieldDefaultValueMap(fieldDefaultValueMap);
		return retobj;
	}

	/***
	 * 添加别名
	 * 
	 * @param aliasTitleList
	 * @param aliasNames     用于检查别名冲突的集合
	 * @param oriColName     原始列名
	 * @param alisColName    别名
	 */
	private static void aliasAdd(List<String> aliasTitleList, List<String> aliasNames, String oriColName,
			String alisColName) {
		// 检查 自定义的别名有没有冲突
		if (aliasNames.contains(alisColName)) {
			throw new ProjectExceptionRuntime(ExceptAll.param_error, "TamsCol的convert配置出现命名冲突，别名为：" + alisColName);
		}
		aliasTitleList.add(String.format("%s,%s", oriColName, alisColName));
		aliasNames.add(alisColName);
	}

	/***
	 * 得到查询列和保存列,这些Field都被TamsCol注解 TamsCol tamsCol =
	 * tamsFields.get(i).getAnnotation(TamsCol.class);
	 * 
	 * @param <T>
	 * @param classz
	 * @return
	 */
	public static <T> Pair<List<Field>, List<Field>> getQuerySaveInfo(Class<T> classz) {
		List<Field> tamsFields = ReflectAssist.findFields(classz, TamsCol.class, new Predicate() {
			@Override
			public boolean evaluate(Object object) {
				TamsCol tamsCol = ((Field) object).getAnnotation(TamsCol.class);
				return !tamsCol.excludeField();
			}
		});
		Collections.sort(tamsFields, TamsCol.comparator);

		List<Field> queryList = new ArrayList<Field>();
		List<Field> saveList = new ArrayList<Field>();
		for (int i = 0; i < tamsFields.size(); i++) {
			TamsCol tamsCol = tamsFields.get(i).getAnnotation(TamsCol.class);
			if (tamsCol.query() >= 0) {
				queryList.add(tamsFields.get(i));
			}
			if (tamsCol.save() >= 0) {
				saveList.add(tamsFields.get(i));
			}
		}
		return Pair.of(queryList, saveList);
	}

	/***
	 * 构造treegrid方法
	 * 
	 * @param fromList       源数据
	 * @param easyUINodeConf 树配置信息
	 * @param aliasTitles    别名列表，中间逗号分隔
	 * @param convertsMap    转换器
	 * @param recordNum      数据条数
	 * @return treegrid要用的json
	 */
	public static String getJsonForTreeGridAlias(List<?> fromList, EasyUINodeConf easyUINodeConf, String[] aliasTitles,
			Map<String, IConvertValue<String>> convertsMap, long recordNum) {
		if (easyUINodeConf == null || StringUtils.isEmpty(easyUINodeConf.getParentCol())) {
			throw new IllegalArgumentException("必须要传入parentCol");
			// aliasTitles = ArrayUtils.add(aliasTitles,
			// String.format("%s,_parentId", parentCol));
		}
		List<String> addAliasTitles = new ArrayList<>();
		if (!ArrayUtils.contains(aliasTitles, "id")) {
			// addAliasTitles.add(String.format("%s,id",
			// easyUINodeConf.getIdCol()));
		}
		if (!ArrayUtils.contains(aliasTitles, "text")) {
			addAliasTitles.add(String.format("%s,text", easyUINodeConf.getTextCol()));
		}
		if (!ArrayUtils.contains(aliasTitles, "_parentId")) {
			addAliasTitles.add(String.format("%s,_parentId", easyUINodeConf.getParentCol()));
		}
		if (StringUtils.isNotEmpty(easyUINodeConf.getIndexCol()) && !ArrayUtils.contains(aliasTitles, "index")) {
			addAliasTitles.add(String.format("%s,index", easyUINodeConf.getIndexCol()));
		}
		if (StringUtils.isNotEmpty(easyUINodeConf.getCheckedCol()) && !ArrayUtils.contains(aliasTitles, "checked")) {
			addAliasTitles.add(String.format("%s,checked", easyUINodeConf.getCheckedCol()));
		}
		if (StringUtils.isNotEmpty(easyUINodeConf.getIconClsCol()) && !ArrayUtils.contains(aliasTitles, "iconCls")) {
			addAliasTitles.add(String.format("%s,iconCls", easyUINodeConf.getIconClsCol()));
		}
		if (StringUtils.isNotEmpty(easyUINodeConf.getIsCloseCol()) && !ArrayUtils.contains(aliasTitles, "state")) {
			addAliasTitles.add(String.format("%s,state", easyUINodeConf.getIsCloseCol()));
		}
		aliasTitles = ArrayUtils.addAll(aliasTitles, addAliasTitles.toArray(new String[addAliasTitles.size()]));
		return getJsonForGridAlias(fromList, aliasTitles, convertsMap, recordNum);
	}

	public static String getJsonForTreeGridAlias(List<?> fromList, EasyUINodeConf easyUINodeConf, long recordNum) {
		return getJsonForTreeGridAlias(fromList, easyUINodeConf, null, null, recordNum);
	}

	/****
	 * 返回空的集合值
	 * 
	 * @return 空的集合值
	 */
	public static String getJsonForGridEmpty() {
		return getJsonForGrid(null, new String[] {}, 0L);
	}

	/****
	 * 把数据以json格式返回，不需要指定已有字段。
	 * 
	 * @param fromList  源业务对象集合
	 * @param recordNum 记录数量（所有页）
	 * @return Grid的String
	 */
	public static String getJsonForGridAlias(List<?> fromList, long recordNum) {
		return getJsonForGridAlias(fromList, null, null, recordNum);
	}

	/***
	 * 指定数据放到Grid里显示
	 * 
	 * @param inputObj 要放到Grid的业务对象数组
	 * @return Grid的String
	 */

	public static String getJsonForGridByObj(Object... inputObj) {
		List retList = new ArrayList();
		if (ArrayUtils.isEmpty(inputObj)) {
			return getJsonForGridAlias(retList, 0);
		}
		for (Object eleObj : inputObj) {
			retList.add(eleObj);
		}
		return getJsonForGridAlias(retList, retList.size());
	}

	/****
	 * 把根节点转为json Str字符串
	 * 
	 * @param nodes 根节点集合
	 * @return 树结果
	 */
	public static String getTreeFromList(EasyUINode... nodes) {
		String retstr = "[]";
		if (ArrayUtils.isEmpty(nodes)) {
			return retstr;
		}
		JSONArray arry = new JSONArray();
		for (EasyUINode easyUINode : nodes) {
			arry.add(easyUINode.toJson());
		}
		return arry.toString();
	}

	/****
	 * 把根节点转为json Str字符串
	 * 
	 * @param nodes 根节点集合
	 * @return 树结果
	 */
	public static String getTreeFromList(List<EasyUINode> nodes) {
		if (CollectionUtils.isEmpty(nodes)) {
			return "[]";
		}
		return getTreeFromList(nodes.toArray(new EasyUINode[nodes.size()]));
	}

	/****
	 * 把List转为根节点集合
	 * 
	 * @param oriList 源业务对象集合
	 * @param conf    树的配置信息
	 * @param <T>     源数据类型
	 * @return 多棵树的对象集合
	 * @throws Exception 转换异常
	 */
	public static <T> List<EasyUINode> getTreeRoot(List<T> oriList, EasyUINodeConf conf) throws Exception {
		if (CollectionUtils.isEmpty(oriList) || conf == null) {
			return new ArrayList<EasyUINode>();
		}
		List<EasyUINode> roots = new ArrayList<EasyUINode>();
		List<EasyUINode> nodes = new ArrayList<EasyUINode>();
		for (Object oriObj : oriList) {
			String id = BeanUtils.getProperty(oriObj, conf.getIdCol());
			String text = "";
			if (conf.getTextConvert() != null) {
				text = conf.getTextConvert().getStr(oriObj);
			} else {
				text = BeanUtils.getProperty(oriObj, conf.getTextCol());
			}
			String parentId = null;
			try {
				parentId = BeanUtils.getProperty(oriObj, conf.getParentCol());
			} catch (Exception e) {
			}
			EasyUINode tempObj = new EasyUINode(id, text);
			tempObj.setParent(new EasyUINode(parentId));
			if (StringUtils.isNotBlank(conf.getIndexCol())) {
				Object indexObj = PropertyUtils.getProperty(oriObj, conf.getIndexCol());
				if (indexObj != null) {
					tempObj.setIndex(new Integer(String.valueOf(indexObj)));
				}
			}
			if (StringUtils.isNotBlank(conf.getIconClsCol())) {
				if (conf.getIconClsCol().startsWith(":")) {
					tempObj.setIconCls(conf.getIconClsCol().substring(1));
				} else {
					tempObj.setIconCls(BeanUtils.getProperty(oriObj, conf.getIconClsCol()));
				}
			}

			if (StringUtils.isNotBlank(conf.getIsCloseCol())) {
				tempObj.setClose(getBoolean(conf.getIsCloseCol(), oriObj, tempObj));
			}

			if (CollectionUtils.isNotEmpty(conf.getCheckedList())) {// 以getCheckedList为主
				if (conf.getCheckedList().contains(id))
					tempObj.setChecked(true);
				else
					tempObj.setChecked(false);
			} else if (StringUtils.isNotBlank(conf.getCheckedCol())) {// 不是Checklist机制则考虑从对象列存放机制
				tempObj.setChecked(getBoolean(conf.getCheckedCol(), oriObj, tempObj));
			}

			// 附加属性
			if (org.apache.commons.lang3.ArrayUtils.isNotEmpty(conf.getAttrCols())) {
				for (String attrCol : conf.getAttrCols()) {
					String attrValue = BeanUtils.getProperty(oriObj, attrCol);
					tempObj.addAttributes(attrCol, StringUtil.hasNull(attrValue));// 为空的也需要添加到属性
				}
			}

			// 其它域，适用于treegrid
			if (org.apache.commons.lang3.ArrayUtils.isNotEmpty(conf.getFieldCols())) {
				for (String fieldCol : conf.getFieldCols()) {
					String fieldValue = BeanUtils.getProperty(oriObj, fieldCol);
					tempObj.addFields(fieldCol, fieldValue);
				}
			}

			if (StringUtils.isBlank(parentId)) {
				tempObj.setParent(null);
				roots.add(tempObj);
			} else if (conf.getIsRoot() != null && conf.getIsRoot().evaluate(parentId)) {
				tempObj.setParent(null);
				roots.add(tempObj);
			} else {
				nodes.add(tempObj);
			}
		}
		if (CollectionUtils.isNotEmpty(nodes)) {
			packNode(roots, nodes);
		}
		return roots;
	}

	private static boolean getBoolean(String valueCol, Object oriObj, EasyUINode tempObj)
			throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
		Object isCloseObj = PropertyUtils.getProperty(oriObj, valueCol);
		String isCloseStr = String.valueOf(isCloseObj);
		if ("true".equals(isCloseStr) || "yes".equalsIgnoreCase(isCloseStr) || "y".equals(isCloseStr)
				|| "1".equals(isCloseStr)) {
			return true;
		} else {
			return false;
		}
	}

	private static void packNode(List<EasyUINode> parentNodes, List<EasyUINode> nodes) {
		if (CollectionUtils.isNotEmpty(parentNodes) && CollectionUtils.isNotEmpty(nodes)) {
			final List<String> rootIds = (List<String>) CollectionUtil.getColFromObj(parentNodes, "id");
			List<EasyUINode> selNodes = (List<EasyUINode>) CollectionUtils.select(nodes, new Predicate() {
				@Override
				public boolean evaluate(Object object) {
					EasyUINode tempObj = (EasyUINode) object;
					return rootIds.contains(tempObj.getParent().getId());
				}
			});
			if (CollectionUtils.isNotEmpty(selNodes)) {
				for (final EasyUINode parentNode : parentNodes) {
					List<EasyUINode> rootSel = (List<EasyUINode>) CollectionUtils.select(selNodes, new Predicate() {
						@Override
						public boolean evaluate(Object object) {
							EasyUINode tmpObj = (EasyUINode) object;
							return parentNode.getId().equals(tmpObj.getParent().getId());
						}
					});
					parentNode.addChildres(rootSel);
				}
				nodes.removeAll(selNodes);
				packNode(selNodes, nodes);
			} else {
				nodes.clear();
			}
		}
	}

	public static Map<String, IConvertValue> getConvertMap(Object... keysAndValues) {
		Map<String, IConvertValue> convertmap = new HashMap<String, IConvertValue>();
		if (ArrayUtils.isEmpty(keysAndValues)) {
			return convertmap;
		}
		int i = 0;
		while (i < keysAndValues.length) {
			convertmap.put(String.valueOf(keysAndValues[i++]), (IConvertValue) keysAndValues[i++]);
		}
		return convertmap;
	}

	/***
	 * 得到grid的str对应的转换器
	 */
	public static IConvertValue<String> getConvert(String jsonStr) {
		JSONObject object = JSONObject.parseObject(jsonStr);
		final JSONArray rows = object.getJSONArray("rows");
		return new IConvertValue<String>() {
			@Override
			public String getStr(String keyObj) {
				if (StringUtil.isNull(keyObj)) {
					return "";
				}
				for (Object row : rows) {
					JSONObject ele = (JSONObject) row;
					if (keyObj.equals(ele.getString("id"))) {
						return ele.getString("name");
					}
				}
				return keyObj;
			}
		};
	}

}
