/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

import com.google.protobuf.ProtocolStringList;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.exception.ExceptAll;

@Slf4j
public abstract class SqlServerAssit {

	public static String[][] getCols(Connection conn, String db, String tb) {
		try {
			PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type   from  " + db
					+ ".information_schema.columns  where  table_catalog=? and table_schema='dbo' and table_name=? order by ORDINAL_POSITION");
			List<String> ret = new ArrayList<>();
			List<String> retType = new ArrayList<>();
			JdbcAssit.setPreParam(prepCols, null,true, db, tb);
			ResultSet rs = prepCols.executeQuery();
			while (rs.next()) {
				ret.add(rs.getString(1));
				retType.add(rs.getString(2));
			}
			rs.close();
			if (CollectionUtils.isEmpty(ret)) {// 库名或表名错误
				throw new RuntimeException("请确认数据为库存在库名：[" + db + "],表名：[" + tb + "]");
			}
			String[][] retAry = new String[2][ret.size()];
			retAry[0] = ret.toArray(new String[ret.size()]);
			retAry[1] = retType.toArray(new String[retType.size()]);
			return retAry;
		} catch (Exception e) {
			log.error("获取cols错误", e);
			throw new RuntimeException("获取cols错误");
		}
	}

//	   MERGE INTO table_A as T
//	   USING (SELECT @Id AS id, @Value AS value ) AS S
//	   ON T.Id = S.id
//	   WHEN MATCHED THEN
//	       UPDATE SET T.Value = S.value
//	   WHEN NOT MATCHED THEN
//	       INSERT(Id, Value) VALUES(S.id, S.value);
	public static Result dataChange(Connection conn, JdbcDatas datas, boolean logicDel) {
		if (datas.getOptType() == OptType.delete && !logicDel) {// 不是逻辑删除
			return MySqlAssit.dataDelete(conn, datas);
		} else {
			return dataUpset(conn, datas, false);
		}
	}

	
	public static Result dataUpset(Connection conn, JdbcDatas datas, boolean batch) {
		List<JdbcData> datasList = datas.getDatasList();
		Object[][] datasInput = new Object[datasList.size()][];
		Date mindate=null;
		try {
			mindate = DateFormatCase.YYYY_MM_DD.getInstanc().parse("1753-01-01");//sqlserver的最小时间值
		} catch (ParseException e) {
		}
		
		for (int i = 0; i < datasList.size(); i++) {
			JdbcData jdbcData = datasList.get(i);
			datasInput[i] = new Object[datas.getColsCount()];
			for (int j = 0; j < datas.getColsCount(); j++) {
				String value = jdbcData.getValueMap().get(datas.getCols(j));
				if (value == null) {
					datasInput[i][j] = value;
				} else {
					BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getCols(j)));
					Serializable value2 = BinlogType.getValue(binlogType, value);
					if(value2 instanceof Date) {//如果是时间要判断最小值为
						Date tempdate=(Date)value2;
						if(tempdate.before(mindate)) {
							value2=mindate;
						}
					}
					datasInput[i][j] = value2;
				}
			}
		}
		Map<String, String> typeMap = datas.getTypeMap();
		ProtocolStringList colsList = datas.getColsList();
		BinlogType[] typeAry = new BinlogType[colsList.size()];
		for (int i = 0; i < typeAry.length; i++) {
			typeAry[i] = BinlogType.valueOf(typeMap.get(colsList.get(i)));
		}
		return dataUpset(conn, datas.getDb(), datas.getTb(), datasInput,
				datas.getColsList().toArray(new String[datas.getColsCount()]), typeAry,
				datas.getKeysList().toArray(new String[datas.getKeysCount()]), batch);
	}

	public static Result dataUpset(Connection conn, String db, String tb, Object[][] datas, String[] cols,
			BinlogType[] typeAry, String[] keys, boolean batch) {
		Object[][] priDatas = new Object[datas.length][];
		try {
			String insertsql = "INSERT(" + CollectionUtil.arrayJoin(cols, ",") + ") VALUES(S."
					+ CollectionUtil.arrayJoin(cols, ", S.") + ")";
			StringBuffer updateBuf = new StringBuffer("UPDATE SET ");
			StringBuffer selectBuf = new StringBuffer("SELECT ");
			for (String col : cols) {
				if (!ArrayUtils.contains(keys, col)) {
					updateBuf.append(String.format("T.%s = S.%s,", col, col));
				}
				selectBuf.append(String.format("? AS %s,", col));
			}

			String selectsql = selectBuf.substring(0, selectBuf.length() - 1);

			StringBuffer keyBuf = new StringBuffer();
			for (String key : keys) {
				keyBuf.append(String.format("and T.%s = S.%s ", key, key));
			}
			String keysql = keyBuf.substring(3);

			// 不能用where语句，会报语法错误。
			// String updatesql = String.format("%s where %s",updateBuf.substring(0,
			// updateBuf.length() - 1), keysql) ;
			String updatesql = updateBuf.substring(0, updateBuf.length() - 1);

			String sql = String.format("MERGE INTO %s.dbo.%s as T " + "USING (%s) AS S  ON %s WHEN MATCHED THEN  %s "
					+ "WHEN NOT MATCHED THEN  %s;", db, tb, selectsql, keysql, updatesql, insertsql);

			PreparedStatement stmt = conn.prepareStatement(sql);
			if (batch) {
				conn.setAutoCommit(false);
				stmt.clearBatch();
				for (int i = 0; i < datas.length; i++) {
					if (i < datas.length - 1) {
						int indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1);
						if (indexOf >= 0) {
							continue;
						}
					}
					JdbcAssit.setPreParam(stmt, typeAry,false, datas[i]);
					stmt.addBatch();
				}
				stmt.executeBatch();
				conn.commit();
			} else {
				conn.setAutoCommit(true);
				for (int i = 0; i < datas.length; i++) {
					if (i < datas.length - 1) {
						int indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1);
						if (indexOf >= 0) {
							continue;
						}
					}
					JdbcAssit.setPreParam(stmt, typeAry,false, datas[i]);
					stmt.execute();
				}
			}
			stmt.close();
			return Result.getSuc();
		} catch (Exception e) {
			log.error("批量插入失败", e);
			return new Result(ExceptAll.jdbc_exec_fail);
		}
	}
}
