/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.jdbc;

import java.util.Objects;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.wicp.tams.common.constant.FieldFormart;

@Getter
@Setter
@ToString
public class MySqlColBean implements Cloneable, Comparable<MySqlColBean> {
	private String db;
	private String tb;
	@Getter(value = AccessLevel.PRIVATE)
	private String columnName;
	private String dataType;
	private String columnType;
	private String columnComment;
	private boolean notNull;//是否不为空，默认为false;
	// 数字:numericPrecision 字符：characterMaximumLength
	private long maxlength;
	private int numericScale;
	private boolean isPri;// 是否为主键
	private int order;// 字段排序，适合于像doris之类的olap数据库，对它来说字段排序很重要
	private boolean isPart;//是否为分区键，像doris会使用。	
	
	private String sqlExpression;//适合flink的字段输出，如proc()
	private String flinkTypeEnum;//flink类型，如果有此字段就,它是net.wicp.tams.common.flink.common.constant.FlinkTypeEnum枚举值
	private String watermarkExpression;//适合flink,定义watermark表达式
	private boolean isMetadata;//是否为meta列
	private String metadataName;//meta列名
	private boolean isVirtual;//是否为虚列

	public MySqlColBean(String columnName, String columnType) {
		this.columnName = columnName;
		this.columnType = columnType;
	}

	public MySqlColBean(String columnName, String dataType, String columnType) {
		this.columnName = columnName;
		this.columnType = columnType;
		this.dataType = dataType;
	}

	@Override
	protected Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	/***
	 * 得到标准的字段
	 * 
	 * @return
	 */
	public String getColumnNameStandard(FieldFormart fieldFormart) {
		return fieldFormart.getColName(this.columnName);
	}

	public MySqlColBean() {

	}

	@Override
	public boolean equals(Object obj) {
		MySqlColBean temp = (MySqlColBean) obj;
		return this.db.equals(temp.getDb()) && this.tb.equals(temp.getTb())
				&& this.columnName.equals(temp.getColumnName());
	}

	@Override
	public int hashCode() {
		return Objects.hash(db, tb, columnName);
	}

	@Override
	public int compareTo(MySqlColBean o) {
		return this.order - o.getOrder();
	}

}
