/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.dic.YesOrNo;

/***
 * jdbc工具类，纯jdbc没有连接池
 * 
 * @author zhoujunhui
 *
 */
@Slf4j
public abstract class JdbcConnection {

	public static Connection getConnection(String driverName, String dburl, String userName, String pwd) {
		Connection conn = null;
		try {
			Class.forName(driverName);
			if (StringUtil.isNull(userName) || StringUtil.isNull(pwd)) {
				conn = DriverManager.getConnection(dburl);
			} else {
				conn = DriverManager.getConnection(dburl, userName, pwd);
			}
			return conn;
		} catch (Exception e) {
			log.error(String.format("连接错误，地址[%s]", dburl), e);
		}
		return null;
	}

	public static Connection getConnection(String driverName, String dburl) {
		return getConnection(driverName, dburl, null, null);
	}

	public static Connection getConnectionMyql(String dburl) {
		return getConnection("com.mysql.jdbc.Driver", dburl);
	}

	public static Connection getConnectionMyql(String dburl, String userName, String pwd) {
		return getConnection("com.mysql.jdbc.Driver", dburl, userName, pwd);
	}

	public static Connection getConnectionMyql(String host, int port, String user, String pwd, YesOrNo isSsh) {
		String url;
		if (isSsh != null && isSsh == YesOrNo.yes) {
			SshAssist.ssh(Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")), host, port);
			url = DbType.mysql.geturl("localhost",
					Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")));
		} else {
			url = DbType.mysql.geturl(host, port);
		}
		java.sql.Connection conn = JdbcConnection.getConnectionMyql(url, user, pwd);
		return conn;
	}
	
	public static Connection getConnection(DbType dbType,String host,int port, String user, String pwd) {
		String connurl = dbType.geturl(host, port);
		return getConnection(dbType.getJdbcDriver(), connurl, user, pwd);
	}
	public static Connection getConnection(DbType dbType,String host, String user, String pwd) {
		return getConnection(dbType, host,dbType.getDefaultPort(),user, pwd);
	}

	public static Connection getConnectionByInstanceId(String dbInstanceId) {
		Properties props = Conf.getPreToProp("common.jdbc.datasource.default", true);
		if (!"default".equals(dbInstanceId)) {
			Map<String, String> map = Conf.getPre("common.jdbc.datasource." + dbInstanceId, true);
			for (String key : map.keySet()) {
				props.put(key, map.get(key));
			}
		}
		String url = DbType.mysql.geturl(get(props, "host"), Integer.parseInt(get(props, "port")));

		return getConnection("com.mysql.jdbc.Driver", url, get(props, "username"), get(props, "password"));
	}

	private static String get(Properties props, String key) {
		return props.get(key) == null ? null : String.valueOf(props.get(key));
	}

	public static void close(Connection conn) {
		try {
			conn.close();
		} catch (Exception e) {
		}
	}

}
