/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcConnection {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnection.class);

    public static Connection getConnection(String driverName, String dburl, String userName, String pwd) {
        Connection conn = null;
        try {
            Class.forName(driverName);
            conn = StringUtil.isNull(userName) || StringUtil.isNull(pwd) ? DriverManager.getConnection(dburl) : DriverManager.getConnection(dburl, userName, pwd);
            return conn;
        }
        catch (Exception e) {
            log.error(String.format("\u8fde\u63a5\u9519\u8bef\uff0c\u5730\u5740[%s]", dburl), (Throwable)e);
            return null;
        }
    }

    public static Connection getConnection(String driverName, String dburl) {
        return JdbcConnection.getConnection(driverName, dburl, null, null);
    }

    public static Connection getConnectionMyql(String dburl) {
        return JdbcConnection.getConnection("com.mysql.jdbc.Driver", dburl);
    }

    public static Connection getConnectionMyql(String dburl, String userName, String pwd) {
        return JdbcConnection.getConnection("com.mysql.jdbc.Driver", dburl, userName, pwd);
    }

    public static Connection getConnectionMyql(String ip, int port, String user, String pwd, YesOrNo isSsh) {
        String url;
        if (isSsh != null && isSsh == YesOrNo.yes) {
            SshAssist.ssh(Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")), ip, port);
            url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", "localhost", Conf.get("common.apiext.ssh.proxy.localhost.port"));
        } else {
            url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", ip, port);
        }
        Connection conn = JdbcConnection.getConnectionMyql(url, user, pwd);
        return conn;
    }
}

