/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.tools;

import java.io.File;
import net.wicp.tams.common.apiext.IOUtil;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.ArrayUtils;

public class PathEndFilter
implements IOFileFilter {
    private final String[] excludePaths;
    private final String[] includePaths;

    public PathEndFilter(String ... excludePaths) {
        this.excludePaths = this.conver(null, excludePaths);
        this.includePaths = null;
    }

    public PathEndFilter(String root, String[] excludePaths) {
        this.excludePaths = this.conver(root, excludePaths);
        this.includePaths = null;
    }

    public PathEndFilter(String root, String[] excludePaths, String[] includePaths) {
        this.excludePaths = this.conver(root, excludePaths);
        this.includePaths = this.conver(root, includePaths);
    }

    private String[] conver(String root, String ... oriArys) {
        if (ArrayUtils.isEmpty((Object[])oriArys)) {
            return new String[0];
        }
        String[] ret = new String[oriArys.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = IOUtil.mergeFolderAndFilePath(root, new String[]{oriArys[i]});
        }
        return ret;
    }

    public boolean accept(File file) {
        boolean eq;
        if (ArrayUtils.isEmpty((Object[])this.excludePaths) && ArrayUtils.isEmpty((Object[])this.includePaths)) {
            return true;
        }
        for (String excludePath : this.excludePaths) {
            eq = this.isFilter(file.getPath(), excludePath);
            if (!eq) continue;
            return false;
        }
        if (ArrayUtils.isNotEmpty((Object[])this.includePaths)) {
            for (String includePath : this.includePaths) {
                eq = this.isFilter(file.getPath(), includePath);
                if (!eq) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isFilter(String thePath, String isPath) {
        String replace = thePath.replace("\\", "/");
        if (isPath.endsWith("/*") || isPath.endsWith("\\*")) {
            String substring = isPath.substring(0, isPath.length() - 2);
            return replace.startsWith(substring);
        }
        return replace.equals(isPath);
    }

    public boolean accept(File dir, String name) {
        if (ArrayUtils.isEmpty((Object[])this.excludePaths) && ArrayUtils.isEmpty((Object[])this.includePaths)) {
            return true;
        }
        for (String excludePath : this.excludePaths) {
            boolean eq = this.isFilter(IOUtil.mergeFolderAndFilePath(dir.getPath(), new String[]{name}), excludePath);
            if (!eq) continue;
            return false;
        }
        if (ArrayUtils.isNotEmpty((Object[])this.includePaths)) {
            for (String includePath : this.includePaths) {
                boolean endsWith = this.isFilter(IOUtil.mergeFolderAndFilePath(dir.getPath(), new String[]{name}), includePath);
                if (!endsWith) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

