package net.wicp.tams.common.apiext.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dbType.BinlogType;

@Slf4j
public abstract class JdbcAssit {

	public static ResultSet querySql(Connection conn, String sql) {
		Statement stmt = null;
		try {
			if (conn == null || conn.isClosed()) {
				return null;
			}
			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			return rs;
		} catch (SQLException e) {
			log.error(String.format("查询sql出错，sql:[%s]", sql), e);
		}
		return null;
	}

	/***
	 * 设置PreparedStatement的参数
	 * 
	 * @param stmt
	 *            要设置参数的PreparedStatement
	 * @param queryParams
	 *            要设置的参数，与stmt出现的问题要对应的上
	 * @throws SQLException
	 *             sql异常
	 */
	public static void setPreParam(PreparedStatement stmt, BinlogType[] typeAry, Object... queryParams)
			throws SQLException {
		if (stmt == null) {
			return;
		}
		int needparamscount = stmt.getParameterMetaData().getParameterCount();
		if (needparamscount == 0 && ArrayUtils.isEmpty(queryParams)) {
			return;
		}
		if (needparamscount != queryParams.length) {
			throw new SQLException(
					String.format("参数的个数不匹配，需要[%s]个参数，但传进来[%s]个参数", needparamscount, queryParams.length));
		}
		for (int i = 0; i < queryParams.length; i++) {
			Object queryParam = queryParams[i];
			if (queryParam == null) {
				if (ArrayUtils.isEmpty(typeAry) || typeAry.length < i + 1) {
					throw new SQLException(String.format("第%s个参数不合法，没有传入typeAry却存在null值", i));
				}
				stmt.setNull(i + 1, typeAry[i].getTypes());
			} else if (queryParam instanceof String) {
				String valueStr = String.valueOf(queryParam);
				stmt.setString(i + 1, valueStr);
			} else if (queryParam instanceof Integer) {
				stmt.setInt(i + 1, (Integer) queryParam);
			} else if (queryParam instanceof Date) {
				stmt.setDate(i + 1, new java.sql.Date(((Date) queryParam).getTime()));
			} else if (queryParam instanceof Long) {
				stmt.setLong(i + 1, (Long) queryParam);
			} else if (queryParam instanceof Double) {
				stmt.setDouble(i + 1, (Double) queryParam);
			} else if (queryParam instanceof Boolean) {
				stmt.setBoolean(i + 1, (Boolean) queryParam);
			} else if (queryParam instanceof byte[]) {
				stmt.setBlob(i + 1, StringUtil.convertInputStream((byte[]) queryParam));
			}else if (queryParam instanceof BigDecimal) {
				stmt.setBigDecimal(i + 1, (BigDecimal)queryParam);
				//stmt.setBlob(i + 1, StringUtil.convertInputStream((byte[]) queryParam));
			} else {
				String valueStr = String.valueOf(queryParam);
				throw new SQLException(String.format("不支持的类型,参数值[%s]", valueStr));
			}
		}

	}

	public static void setPreParam(PreparedStatement stmt, Object... queryParams) throws SQLException {
		setPreParam(stmt, null, queryParams);
	}

	public static List<Map<String, String>> querySqlMap(Connection conn, String sql) {
		ResultSet rs = querySql(conn, sql);
		List<Map<String, String>> retlist = new ArrayList<>();
		try {
			int nums = rs.getMetaData().getColumnCount();
			while (rs.next()) {
				Map<String, String> retmap = new HashMap<>();
				for (int i = 0; i < nums; i++) {
					String colName = rs.getMetaData().getColumnLabel(i + 1);
					String value = rs.getString(colName);
					retmap.put(colName, value);
				}
				retlist.add(retmap);
			}
			return retlist;
		} catch (Exception e) {
			log.error(String.format("查询sql出错，sql:[%s]", sql), e);
			return null;
		}
	}
}
