/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.EPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSinfo {
    private static final Logger log = LoggerFactory.getLogger(OSinfo.class);
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static OSinfo _instance = new OSinfo();
    private EPlatform platform;

    private OSinfo() {
    }

    public static boolean isLinux() {
        return OS.indexOf("linux") >= 0;
    }

    public static boolean isMacOS() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") < 0;
    }

    public static boolean isMacOSX() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") > 0;
    }

    public static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    public static boolean isOS2() {
        return OS.indexOf("os/2") >= 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("solaris") >= 0;
    }

    public static boolean isSunOS() {
        return OS.indexOf("sunos") >= 0;
    }

    public static boolean isMPEiX() {
        return OS.indexOf("mpe/ix") >= 0;
    }

    public static boolean isHPUX() {
        return OS.indexOf("hp-ux") >= 0;
    }

    public static boolean isAix() {
        return OS.indexOf("aix") >= 0;
    }

    public static boolean isOS390() {
        return OS.indexOf("os/390") >= 0;
    }

    public static boolean isFreeBSD() {
        return OS.indexOf("freebsd") >= 0;
    }

    public static boolean isIrix() {
        return OS.indexOf("irix") >= 0;
    }

    public static boolean isDigitalUnix() {
        return OS.indexOf("digital") >= 0 && OS.indexOf("unix") > 0;
    }

    public static boolean isNetWare() {
        return OS.indexOf("netware") >= 0;
    }

    public static boolean isOSF1() {
        return OS.indexOf("osf1") >= 0;
    }

    public static boolean isOpenVMS() {
        return OS.indexOf("openvms") >= 0;
    }

    public static EPlatform getOSname() {
        OSinfo._instance.platform = OSinfo.isAix() ? EPlatform.AIX : (OSinfo.isDigitalUnix() ? EPlatform.Digital_Unix : (OSinfo.isFreeBSD() ? EPlatform.FreeBSD : (OSinfo.isHPUX() ? EPlatform.HP_UX : (OSinfo.isIrix() ? EPlatform.Irix : (OSinfo.isLinux() ? EPlatform.Linux : (OSinfo.isMacOS() ? EPlatform.Mac_OS : (OSinfo.isMacOSX() ? EPlatform.Mac_OS_X : (OSinfo.isMPEiX() ? EPlatform.MPEiX : (OSinfo.isNetWare() ? EPlatform.NetWare_411 : (OSinfo.isOpenVMS() ? EPlatform.OpenVMS : (OSinfo.isOS2() ? EPlatform.OS2 : (OSinfo.isOS390() ? EPlatform.OS390 : (OSinfo.isOSF1() ? EPlatform.OSF1 : (OSinfo.isSolaris() ? EPlatform.Solaris : (OSinfo.isSunOS() ? EPlatform.SunOS : (OSinfo.isWindows() ? EPlatform.Windows : EPlatform.Others))))))))))))))));
        return OSinfo._instance.platform;
    }

    public static String findIpAddressTrue() {
        return StringUtil.isNull(Conf.get("common.apiext.os.ip")) ? OSinfo.findFirstNonLoopbackAddress().getHostAddress() : Conf.get("common.apiext.os.ip");
    }

    public static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                log.trace("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                if (OSinfo.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || OSinfo.ignoreAddress(address)) continue;
                    log.trace("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            log.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("Unable to retrieve localhost");
            return null;
        }
    }

    private static boolean ignoreInterface(String interfaceName) {
        String[] macnameAry;
        String macnames = Conf.get("common.apiext.os.ignore.mac");
        if (StringUtil.isNull(macnames)) {
            return false;
        }
        for (String regex : macnameAry = macnames.split(",")) {
            if (!interfaceName.matches(regex)) continue;
            log.trace("Ignoring interface: " + interfaceName);
            return true;
        }
        return false;
    }

    private static boolean ignoreAddress(InetAddress address) {
        String[] ipAry;
        String ips = Conf.get("common.apiext.os.ignore.ip");
        if (StringUtil.isNull(ips)) {
            return false;
        }
        for (String regex : ipAry = ips.split(",")) {
            if (address.getHostAddress().matches(regex) || address.getHostAddress().startsWith(regex)) continue;
            log.trace("Ignoring address: " + address.getHostAddress());
            return true;
        }
        return false;
    }
}

