/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum FlinkResItem {
    jm_mem_heap("JM \u5806\u5185\u5b58", -1, "jobmanager.memory.heap.size", true),
    jm_mem_heapoff("JM \u5806\u5916\u5185\u5b58", 128, "jobmanager.memory.off-heap.size", true),
    jm_mem_jvmmeta("JM JVM\u5143\u6570\u636e", 256, "jobmanager.memory.jvm-metaspace.size", true),
    jm_mem_jvmoverhead("JM JVM\u5f00\u9500", 192, "jobmanager.memory.jvm-overhead.min", true),
    jm_cpu("JM CPU(ms)", 1000, "kubernetes.jobmanager.cpu", true),
    tm_mem_heap_slot("TM \u5355\u69fd\u5806\u5185\u5b58", -1, "taskmanager.memory.task.heap.size", true),
    tm_mem_heap_frame("TM \u6846\u67b6\u5806\u5185\u5b58", 128, "taskmanager.memory.framework.heap.size", true),
    tm_mem_managed("TM \u7ba1\u7406\u5185\u5b58\u5360\u6bd4(\u767e\u5206\u6bd4)", 40, "taskmanager.memory.managed.fraction", true),
    tm_mem_heapoff_frame("TM \u6846\u67b6\u5806\u5916\u5185\u5b58", 128, "taskmanager.memory.framework.off-heap.size", true),
    tm_mem_heapoff_task("TM \u4efb\u52a1\u5806\u5916\u5185\u5b58", 0, "taskmanager.memory.task.off-heap.size", true),
    tm_mem_network("TM \u7f51\u7edc\u5185\u5b58\u5360\u6bd4(\u767e\u5206\u6bd4)", 10, "taskmanager.memory.network.fraction", true),
    tm_mem_jvmoverhead("TM JVM\u5f00\u9500", 192, "taskmanager.memory.jvm-overhead.min", true),
    tm_mem_jvmmeta("TM JVM\u5143\u6570\u636e", 256, "taskmanager.memory.jvm-metaspace.size", true),
    tm_mem_proc("\u6574\u4e2a\u8fdb\u7a0b\u7684\u5185\u5b58", -1, "taskmanager.memory.process.size", false),
    tm_cpu_slot("TM \u5355\u69fdCPU(ms)", -1, "kubernetes.taskmanager.cpu", true);

    private final String desc;
    private final String key;
    private final boolean tbFieldInclude;
    private final int value;

    public boolean isTbFieldInclude() {
        return this.tbFieldInclude;
    }

    public String getKey() {
        return this.key;
    }

    public final <T> int getValue(T dataObj) {
        if (dataObj == null) {
            return this.getValue();
        }
        try {
            Object property = PropertyUtils.getProperty(dataObj, (String)StringUtil.convertStr(this.name()));
            return Integer.parseInt(String.valueOf(property));
        }
        catch (Exception e) {
            return this.getValue();
        }
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private FlinkResItem(String desc, int value, String key, boolean tbFieldInclude) {
        this.desc = desc;
        this.value = value;
        this.key = key;
        this.tbFieldInclude = tbFieldInclude;
    }

    public static int getJmMenDefault(int heap) {
        return heap + jm_mem_heapoff.getValue() + jm_mem_jvmmeta.getValue() + jm_mem_jvmoverhead.getValue();
    }

    public static <T> int getJmMen(T dataObj) {
        return FlinkResItem.getJmMenDefault(jm_mem_heap.getValue(dataObj));
    }

    public static Pair<Integer, Short> getTmMenDefault(short slot) {
        return FlinkResItem.getTmMen(slot, Integer.MAX_VALUE, null);
    }

    public static <T> Pair<Integer, Short> getTmMen(short slot, int destMenPreTask, T dataObj) {
        return FlinkResItem.getTmMen(slot, destMenPreTask, (short)1, dataObj);
    }

    private static <T> Pair<Integer, Short> getTmMen(short slot, int destMenPreTask, short destTaskNum, T dataObj) {
        int slotHeap = tm_mem_heap_slot.getValue(dataObj);
        short slotPreTask = (short)(slot / destTaskNum + (slot % destTaskNum > 0 ? 1 : 0));
        int other = tm_mem_heap_frame.getValue(dataObj) + tm_mem_heapoff_frame.getValue(dataObj) + tm_mem_heapoff_task.getValue(dataObj) + slotHeap * slotPreTask;
        int networkPer = tm_mem_network.getValue(dataObj);
        boolean isMultTask = destTaskNum > 1;
        int flinkMem = networkPer > 0 && isMultTask ? other * 100 / (100 - tm_mem_managed.getValue(dataObj) - networkPer) : (other + 64) * 100 / (100 - tm_mem_managed.getValue(dataObj));
        int procMem = flinkMem + tm_mem_jvmmeta.getValue(dataObj) + tm_mem_jvmoverhead.getValue(dataObj);
        if (procMem <= destMenPreTask) {
            return Pair.of((Object)procMem, (Object)destTaskNum);
        }
        return FlinkResItem.getTmMen((short)(slotPreTask - 1), destMenPreTask, (short)(destTaskNum + 1), dataObj);
    }

    public static <T> double getTmCpu(short slotPerTask, T dataObj) {
        if (dataObj == null || tm_cpu_slot.getValue(dataObj) == -1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "tm\u9700\u8981\u4f20\u5165\u6bcf\u4e2a\u69fd\u8981\u7528\u7684cpu");
        }
        return (double)(tm_cpu_slot.getValue(dataObj) * slotPerTask) / 1000.0;
    }

    public static <T> double getJmCpu(T dataObj) {
        return (double)jm_cpu.getValue(dataObj) / 1000.0;
    }

    public static <T> Map<String, String> config(short slot, int destMenPreTask, T dataObj) {
        boolean isMultTask;
        HashMap<String, String> retmap = new HashMap<String, String>();
        retmap.put(jm_mem_heap.getKey(), String.valueOf(jm_mem_heap.getValue(dataObj)) + "m");
        retmap.put(jm_mem_heapoff.getKey(), String.valueOf(jm_mem_heapoff.getValue(dataObj)) + "m");
        retmap.put(jm_mem_jvmmeta.getKey(), String.valueOf(jm_mem_jvmmeta.getValue(dataObj)) + "m");
        retmap.put("jobmanager.memory.jvm-overhead.min", String.valueOf(jm_mem_jvmoverhead.getValue(dataObj)) + "m");
        retmap.put("jobmanager.memory.jvm-overhead.max", String.valueOf(jm_mem_jvmoverhead.getValue(dataObj)) + "m");
        retmap.put(jm_cpu.getKey(), String.valueOf((double)jm_cpu.getValue(dataObj) / 1000.0));
        Pair<Integer, Short> tmMenAndNum = FlinkResItem.getTmMen(slot, destMenPreTask, dataObj);
        retmap.put(tm_mem_proc.getKey(), String.valueOf((Integer)tmMenAndNum.getLeft()) + "m");
        retmap.put(tm_mem_heap_frame.getKey(), String.valueOf(tm_mem_heap_frame.getValue(dataObj)) + "m");
        retmap.put(tm_mem_managed.getKey(), String.valueOf((double)tm_mem_managed.getValue(dataObj) / 100.0));
        retmap.put(tm_mem_heapoff_frame.getKey(), String.valueOf(tm_mem_heapoff_frame.getValue(dataObj)) + "m");
        retmap.put(tm_mem_heapoff_task.getKey(), String.valueOf(tm_mem_heapoff_task.getValue(dataObj)) + "m");
        int networkPer = tm_mem_network.getValue(dataObj);
        boolean bl = isMultTask = ((Short)tmMenAndNum.getRight()).intValue() > 1;
        if (networkPer > 0 && isMultTask) {
            retmap.put(tm_mem_network.getKey(), String.valueOf((double)tm_mem_network.getValue(dataObj) / 100.0));
        } else {
            retmap.put("taskmanager.memory.network.min", "64m");
            retmap.put("taskmanager.memory.network.max", "64m");
        }
        retmap.put("taskmanager.memory.jvm-overhead.min", String.valueOf(tm_mem_jvmoverhead.getValue(dataObj)) + "m");
        retmap.put("taskmanager.memory.jvm-overhead.max", String.valueOf(tm_mem_jvmoverhead.getValue(dataObj)) + "m");
        retmap.put(tm_mem_jvmmeta.getKey(), String.valueOf(tm_mem_jvmmeta.getValue(dataObj)) + "m");
        retmap.put(tm_cpu_slot.getKey(), String.valueOf((double)(tm_cpu_slot.getValue(dataObj) * slot) / 1000.0));
        short numPerTask = (short)(slot / (Short)tmMenAndNum.getRight() + (slot % (Short)tmMenAndNum.getRight() > 0 ? 1 : 0));
        retmap.put("taskmanager.numberOfTaskSlots", String.valueOf(numPerTask));
        return retmap;
    }
}

