/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.StringUtil;

public enum FilterPattern {
    left("\u5de6\u8fb9\u5339\u914d"),
    right("\u53f3\u8fb9\u5339\u914d"),
    contains("\u4efb\u610f\u5339\u914d"),
    length("\u957f\u5ea6\u76f8\u7b49\u5339\u914d");

    private final String desc;

    private FilterPattern(String desc) {
        this.desc = desc;
    }

    public boolean check(String checkStr, String fitStr) {
        boolean ret = false;
        checkStr = StringUtil.trimSpace(checkStr);
        fitStr = StringUtil.trimSpace(fitStr);
        switch (this) {
            case left: {
                ret = checkStr.startsWith(fitStr);
                break;
            }
            case right: {
                ret = checkStr.endsWith(fitStr);
                break;
            }
            case contains: {
                ret = checkStr.contains(fitStr);
                break;
            }
            case length: {
                ret = checkStr.startsWith(fitStr);
                break;
            }
        }
        return ret;
    }

    public static FilterPattern getByName(String pathpath) {
        if (StringUtil.isNull(pathpath)) {
            return contains;
        }
        for (FilterPattern ele : FilterPattern.values()) {
            if (!pathpath.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return contains;
    }

    public String getDesc() {
        return this.desc;
    }
}

