/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertValueEnum
implements IConvertValue<String> {
    private static final Logger log = LoggerFactory.getLogger(ConvertValueEnum.class);
    private Object[] objs;
    private String lan;

    public ConvertValueEnum(Object[] obj, String lan) {
        this.objs = obj;
        this.lan = lan;
    }

    public ConvertValueEnum(Class classobj, String lan) {
        this.objs = classobj.getEnumConstants();
        this.lan = lan;
    }

    public ConvertValueEnum(Class classobj) {
        this(classobj, Conf.get("common.apiext.i18n"));
    }

    public ConvertValueEnum(String className, String lan) {
        try {
            Class<?> classobj = Class.forName(className);
            this.objs = classobj.getEnumConstants();
            this.lan = lan;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public String getStr(String key) {
        if (StringUtil.isNull(key) || ArrayUtils.isEmpty((Object[])this.objs)) {
            return key;
        }
        Object[] keyeles = key.split(",", 0);
        Object[] values = (String[])keyeles.clone();
        String filed = StringUtil.isNull(this.lan) ? "desc" : String.format("desc_%s", this.lan);
        for (Object object : this.objs) {
            IEnumCombobox tempobj = (IEnumCombobox)object;
            int indexOf = ArrayUtils.indexOf((Object[])keyeles, (Object)tempobj.getName());
            if (indexOf < 0) continue;
            try {
                values[indexOf] = BeanUtils.getSimpleProperty((Object)tempobj, (String)filed);
            }
            catch (Exception e) {
                log.error("enum value[" + (String)keyeles[indexOf] + "] convert error", (Throwable)e);
            }
        }
        return CollectionUtil.arrayJoin(values, ",");
    }
}

